/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.util.ImmutableObjectUtils;
import software.amazon.awssdk.utils.Base64Utils;

public class EC2RequestHandler
extends RequestHandler {
    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        ModifyReservedInstancesRequest modifyReservedInstancesRequest;
        Object originalRequest = ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getOriginalRequest();
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        if (originalRequest instanceof ImportKeyPairRequest) {
            ImportKeyPairRequest importKeyPairRequest = (ImportKeyPairRequest)((Object)originalRequest);
            String publicKeyMaterial = importKeyPairRequest.publicKeyMaterial();
            String encodedKeyMaterial = Base64Utils.encodeAsString((byte[])publicKeyMaterial.getBytes(StandardCharsets.UTF_8));
            mutableRequest.queryParameter("PublicKeyMaterial", encodedKeyMaterial);
        } else if (originalRequest instanceof RequestSpotInstancesRequest) {
            RequestSpotInstancesRequest requestSpotInstancesRequest = (RequestSpotInstancesRequest)((Object)originalRequest);
            int groupNameCount = 1;
            for (String groupName : requestSpotInstancesRequest.launchSpecification().securityGroups()) {
                mutableRequest.queryParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, groupName);
            }
            int groupIdCount = 1;
            for (GroupIdentifier group : requestSpotInstancesRequest.launchSpecification().allSecurityGroups()) {
                if (group.groupId() != null) {
                    mutableRequest.queryParameter("LaunchSpecification.SecurityGroupId." + groupIdCount++, group.groupId());
                }
                if (group.groupName() == null) continue;
                mutableRequest.queryParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, group.groupName());
            }
            request.getParameters().keySet().stream().filter(parameter -> parameter.startsWith("LaunchSpecification.GroupSet.")).forEach(arg_0 -> ((SdkHttpFullRequest.Builder)mutableRequest).removeQueryParameter(arg_0));
        } else if (originalRequest instanceof RunInstancesRequest) {
            RunInstancesRequest runInstancesRequest = (RunInstancesRequest)((Object)originalRequest);
            if (runInstancesRequest.clientToken() == null) {
                mutableRequest.queryParameter("ClientToken", UUID.randomUUID().toString());
            }
        } else if (originalRequest instanceof ModifyReservedInstancesRequest && (modifyReservedInstancesRequest = (ModifyReservedInstancesRequest)((Object)originalRequest)).clientToken() == null) {
            mutableRequest.queryParameter("ClientToken", UUID.randomUUID().toString());
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    public void afterResponse(SdkHttpFullRequest request, Response<?> response) {
        Object awsResponse = response.getAwsResponse();
        if (awsResponse instanceof DescribeSpotInstanceRequestsResponse) {
            DescribeSpotInstanceRequestsResponse result = (DescribeSpotInstanceRequestsResponse)((Object)awsResponse);
            for (SpotInstanceRequest spotInstanceRequest : result.spotInstanceRequests()) {
                LaunchSpecification launchSpecification = spotInstanceRequest.launchSpecification();
                this.populateLaunchSpecificationSecurityGroupNames(launchSpecification);
            }
        } else if (awsResponse instanceof RequestSpotInstancesResponse) {
            RequestSpotInstancesResponse result = (RequestSpotInstancesResponse)((Object)awsResponse);
            for (SpotInstanceRequest spotInstanceRequest : result.spotInstanceRequests()) {
                LaunchSpecification launchSpecification = spotInstanceRequest.launchSpecification();
                this.populateLaunchSpecificationSecurityGroupNames(launchSpecification);
            }
        } else if (awsResponse instanceof DescribeInstancesResponse) {
            ((DescribeInstancesResponse)((Object)awsResponse)).reservations().forEach(this::populateReservationSecurityGroupNames);
        } else if (awsResponse instanceof RunInstancesResponse) {
            this.populateReservationSecurityGroupNames(((RunInstancesResponse)((Object)awsResponse)).reservation());
        }
    }

    private void populateReservationSecurityGroupNames(Reservation reservation) {
        List groupNames = reservation.groups().stream().map(GroupIdentifier::groupName).collect(Collectors.toList());
        ImmutableObjectUtils.setObjectMember((Object)reservation, (String)"groupNames", groupNames);
    }

    private void populateLaunchSpecificationSecurityGroupNames(LaunchSpecification launchSpecification) {
        List groupNames = launchSpecification.allSecurityGroups().stream().map(GroupIdentifier::groupName).collect(Collectors.toList());
        ImmutableObjectUtils.setObjectMember((Object)launchSpecification, (String)"securityGroups", groupNames);
    }
}

