/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeFpgaImagesRequestMarshaller
implements Marshaller<Request<DescribeFpgaImagesRequest>, DescribeFpgaImagesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeFpgaImagesRequest> marshall(DescribeFpgaImagesRequest describeFpgaImagesRequest) {
        List<Filter> describeFpgaImagesRequestFiltersList;
        List<String> describeFpgaImagesRequestOwnersList;
        if (describeFpgaImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFpgaImagesRequest, "EC2Client");
        request.addParameter("Action", "DescribeFpgaImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeFpgaImagesRequestFpgaImageIdsList = describeFpgaImagesRequest.fpgaImageIds();
        if (describeFpgaImagesRequestFpgaImageIdsList != null) {
            int fpgaImageIdsListIndex = 1;
            for (String string : describeFpgaImagesRequestFpgaImageIdsList) {
                if (string != null) {
                    request.addParameter("FpgaImageId." + fpgaImageIdsListIndex, StringUtils.fromString((String)string));
                }
                ++fpgaImageIdsListIndex;
            }
        }
        if ((describeFpgaImagesRequestOwnersList = describeFpgaImagesRequest.owners()) != null) {
            int ownersListIndex = 1;
            for (String describeFpgaImagesRequestOwnersListValue : describeFpgaImagesRequestOwnersList) {
                if (describeFpgaImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString((String)describeFpgaImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        if ((describeFpgaImagesRequestFiltersList = describeFpgaImagesRequest.filters()) != null) {
            boolean bl = true;
            for (Filter describeFpgaImagesRequestFiltersListValue : describeFpgaImagesRequestFiltersList) {
                List<String> filterValuesList;
                void var6_12;
                if (describeFpgaImagesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + (int)var6_12 + ".Name", StringUtils.fromString((String)describeFpgaImagesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeFpgaImagesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + (int)var6_12 + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++var6_12;
            }
        }
        if (describeFpgaImagesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFpgaImagesRequest.nextToken()));
        }
        if (describeFpgaImagesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFpgaImagesRequest.maxResults()));
        }
        return request;
    }
}

