/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateSubnetRequestMarshaller
implements Marshaller<Request<CreateSubnetRequest>, CreateSubnetRequest> {
    public Request<CreateSubnetRequest> marshall(CreateSubnetRequest createSubnetRequest) {
        if (createSubnetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSubnetRequest, "EC2Client");
        request.addParameter("Action", "CreateSubnet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSubnetRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createSubnetRequest.availabilityZone()));
        }
        if (createSubnetRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createSubnetRequest.cidrBlock()));
        }
        if (createSubnetRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)createSubnetRequest.ipv6CidrBlock()));
        }
        if (createSubnetRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createSubnetRequest.vpcId()));
        }
        return request;
    }
}

