/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.StaleIpPermission;
import software.amazon.awssdk.services.ec2.model.StaleIpPermissionSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StaleSecurityGroup
implements ToCopyableBuilder<Builder, StaleSecurityGroup> {
    private final String description;
    private final String groupId;
    private final String groupName;
    private final List<StaleIpPermission> staleIpPermissions;
    private final List<StaleIpPermission> staleIpPermissionsEgress;
    private final String vpcId;

    private StaleSecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.staleIpPermissions = builder.staleIpPermissions;
        this.staleIpPermissionsEgress = builder.staleIpPermissionsEgress;
        this.vpcId = builder.vpcId;
    }

    public String description() {
        return this.description;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<StaleIpPermission> staleIpPermissions() {
        return this.staleIpPermissions;
    }

    public List<StaleIpPermission> staleIpPermissionsEgress() {
        return this.staleIpPermissionsEgress;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.staleIpPermissions() == null ? 0 : this.staleIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.staleIpPermissionsEgress() == null ? 0 : this.staleIpPermissionsEgress().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.staleIpPermissions() == null ^ this.staleIpPermissions() == null) {
            return false;
        }
        if (other.staleIpPermissions() != null && !other.staleIpPermissions().equals(this.staleIpPermissions())) {
            return false;
        }
        if (other.staleIpPermissionsEgress() == null ^ this.staleIpPermissionsEgress() == null) {
            return false;
        }
        if (other.staleIpPermissionsEgress() != null && !other.staleIpPermissionsEgress().equals(this.staleIpPermissionsEgress())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.staleIpPermissions() != null) {
            sb.append("StaleIpPermissions: ").append(this.staleIpPermissions()).append(",");
        }
        if (this.staleIpPermissionsEgress() != null) {
            sb.append("StaleIpPermissionsEgress: ").append(this.staleIpPermissionsEgress()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupId;
        private String groupName;
        private List<StaleIpPermission> staleIpPermissions;
        private List<StaleIpPermission> staleIpPermissionsEgress;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleSecurityGroup model) {
            this.setDescription(model.description);
            this.setGroupId(model.groupId);
            this.setGroupName(model.groupName);
            this.setStaleIpPermissions(model.staleIpPermissions);
            this.setStaleIpPermissionsEgress(model.staleIpPermissionsEgress);
            this.setVpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<StaleIpPermission> getStaleIpPermissions() {
            return this.staleIpPermissions;
        }

        @Override
        public final Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(StaleIpPermission ... staleIpPermissions) {
            this.staleIpPermissions(Arrays.asList(staleIpPermissions));
            return this;
        }

        public final void setStaleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
        }

        @SafeVarargs
        public final void setStaleIpPermissions(StaleIpPermission ... staleIpPermissions) {
            this.staleIpPermissions(Arrays.asList(staleIpPermissions));
        }

        public final Collection<StaleIpPermission> getStaleIpPermissionsEgress() {
            return this.staleIpPermissionsEgress;
        }

        @Override
        public final Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(StaleIpPermission ... staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
            return this;
        }

        public final void setStaleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
        }

        @SafeVarargs
        public final void setStaleIpPermissionsEgress(StaleIpPermission ... staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public StaleSecurityGroup build() {
            return new StaleSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StaleSecurityGroup> {
        public Builder description(String var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder staleIpPermissions(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissions(StaleIpPermission ... var1);

        public Builder staleIpPermissionsEgress(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissionsEgress(StaleIpPermission ... var1);

        public Builder vpcId(String var1);
    }
}

