/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressConfigSetCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesSecurityGroupIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstancesNetworkInterface
implements ToCopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
    private final Boolean associatePublicIpAddress;
    private final Boolean deleteOnTermination;
    private final String description;
    private final Integer deviceIndex;
    private final List<String> groups;
    private final Integer ipv6AddressCount;
    private final List<ScheduledInstancesIpv6Address> ipv6Addresses;
    private final String networkInterfaceId;
    private final String privateIpAddress;
    private final List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;
    private final Integer secondaryPrivateIpAddressCount;
    private final String subnetId;

    private ScheduledInstancesNetworkInterface(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddressConfigs = builder.privateIpAddressConfigs;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String description() {
        return this.description;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public List<String> groups() {
        return this.groups;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<ScheduledInstancesIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs() {
        return this.privateIpAddressConfigs;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associatePublicIpAddress() == null ? 0 : this.associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.deleteOnTermination() == null ? 0 : this.deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.deviceIndex() == null ? 0 : this.deviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.ipv6AddressCount() == null ? 0 : this.ipv6AddressCount().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Addresses() == null ? 0 : this.ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddressConfigs() == null ? 0 : this.privateIpAddressConfigs().hashCode());
        hashCode = 31 * hashCode + (this.secondaryPrivateIpAddressCount() == null ? 0 : this.secondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesNetworkInterface)) {
            return false;
        }
        ScheduledInstancesNetworkInterface other = (ScheduledInstancesNetworkInterface)obj;
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.ipv6AddressCount() == null ^ this.ipv6AddressCount() == null) {
            return false;
        }
        if (other.ipv6AddressCount() != null && !other.ipv6AddressCount().equals(this.ipv6AddressCount())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddressConfigs() == null ^ this.privateIpAddressConfigs() == null) {
            return false;
        }
        if (other.privateIpAddressConfigs() != null && !other.privateIpAddressConfigs().equals(this.privateIpAddressConfigs())) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() == null ^ this.secondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() != null && !other.secondaryPrivateIpAddressCount().equals(this.secondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        return other.subnetId() == null || other.subnetId().equals(this.subnetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.associatePublicIpAddress()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(this.deviceIndex()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.ipv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(this.ipv6AddressCount()).append(",");
        }
        if (this.ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.ipv6Addresses()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.privateIpAddressConfigs() != null) {
            sb.append("PrivateIpAddressConfigs: ").append(this.privateIpAddressConfigs()).append(",");
        }
        if (this.secondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(this.secondaryPrivateIpAddressCount()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean deleteOnTermination;
        private String description;
        private Integer deviceIndex;
        private List<String> groups;
        private Integer ipv6AddressCount;
        private List<ScheduledInstancesIpv6Address> ipv6Addresses;
        private String networkInterfaceId;
        private String privateIpAddress;
        private List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;
        private Integer secondaryPrivateIpAddressCount;
        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesNetworkInterface model) {
            this.setAssociatePublicIpAddress(model.associatePublicIpAddress);
            this.setDeleteOnTermination(model.deleteOnTermination);
            this.setDescription(model.description);
            this.setDeviceIndex(model.deviceIndex);
            this.setGroups(model.groups);
            this.setIpv6AddressCount(model.ipv6AddressCount);
            this.setIpv6Addresses(model.ipv6Addresses);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setPrivateIpAddressConfigs(model.privateIpAddressConfigs);
            this.setSecondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.setSubnetId(model.subnetId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(String ... groups) {
            this.groups(Arrays.asList(groups));
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<ScheduledInstancesIpv6Address> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(ScheduledInstancesIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(ScheduledInstancesIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ScheduledInstancesPrivateIpAddressConfig> getPrivateIpAddressConfigs() {
            return this.privateIpAddressConfigs;
        }

        @Override
        public final Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... privateIpAddressConfigs) {
            this.privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
            return this;
        }

        public final void setPrivateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
        }

        @SafeVarargs
        public final void setPrivateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... privateIpAddressConfigs) {
            this.privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public ScheduledInstancesNetworkInterface build() {
            return new ScheduledInstancesNetworkInterface(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder description(String var1);

        public Builder deviceIndex(Integer var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> var1);

        public Builder ipv6Addresses(ScheduledInstancesIpv6Address ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> var1);

        public Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder subnetId(String var1);
    }
}

