/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.ProductCodeValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProductCode
implements ToCopyableBuilder<Builder, ProductCode> {
    private final String productCodeId;
    private final String productCodeType;

    private ProductCode(BuilderImpl builder) {
        this.productCodeId = builder.productCodeId;
        this.productCodeType = builder.productCodeType;
    }

    public String productCodeId() {
        return this.productCodeId;
    }

    public String productCodeType() {
        return this.productCodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productCodeId() == null ? 0 : this.productCodeId().hashCode());
        hashCode = 31 * hashCode + (this.productCodeType() == null ? 0 : this.productCodeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductCode)) {
            return false;
        }
        ProductCode other = (ProductCode)obj;
        if (other.productCodeId() == null ^ this.productCodeId() == null) {
            return false;
        }
        if (other.productCodeId() != null && !other.productCodeId().equals(this.productCodeId())) {
            return false;
        }
        if (other.productCodeType() == null ^ this.productCodeType() == null) {
            return false;
        }
        return other.productCodeType() == null || other.productCodeType().equals(this.productCodeType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.productCodeId() != null) {
            sb.append("ProductCodeId: ").append(this.productCodeId()).append(",");
        }
        if (this.productCodeType() != null) {
            sb.append("ProductCodeType: ").append(this.productCodeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String productCodeId;
        private String productCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductCode model) {
            this.setProductCodeId(model.productCodeId);
            this.setProductCodeType(model.productCodeType);
        }

        public final String getProductCodeId() {
            return this.productCodeId;
        }

        @Override
        public final Builder productCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
            return this;
        }

        public final void setProductCodeId(String productCodeId) {
            this.productCodeId = productCodeId;
        }

        public final String getProductCodeType() {
            return this.productCodeType;
        }

        @Override
        public final Builder productCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
            return this;
        }

        @Override
        public final Builder productCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
            return this;
        }

        public final void setProductCodeType(String productCodeType) {
            this.productCodeType = productCodeType;
        }

        public final void setProductCodeType(ProductCodeValues productCodeType) {
            this.productCodeType(productCodeType.toString());
        }

        public ProductCode build() {
            return new ProductCode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProductCode> {
        public Builder productCodeId(String var1);

        public Builder productCodeType(String var1);

        public Builder productCodeType(ProductCodeValues var1);
    }
}

