/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntry;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntryListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkAcl
implements ToCopyableBuilder<Builder, NetworkAcl> {
    private final List<NetworkAclAssociation> associations;
    private final List<NetworkAclEntry> entries;
    private final Boolean isDefault;
    private final String networkAclId;
    private final List<Tag> tags;
    private final String vpcId;

    private NetworkAcl(BuilderImpl builder) {
        this.associations = builder.associations;
        this.entries = builder.entries;
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public List<NetworkAclAssociation> associations() {
        return this.associations;
    }

    public List<NetworkAclEntry> entries() {
        return this.entries;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associations() == null ? 0 : this.associations().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        hashCode = 31 * hashCode + (this.networkAclId() == null ? 0 : this.networkAclId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl)obj;
        if (other.associations() == null ^ this.associations() == null) {
            return false;
        }
        if (other.associations() != null && !other.associations().equals(this.associations())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associations() != null) {
            sb.append("Associations: ").append(this.associations()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: ").append(this.isDefault()).append(",");
        }
        if (this.networkAclId() != null) {
            sb.append("NetworkAclId: ").append(this.networkAclId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<NetworkAclAssociation> associations;
        private List<NetworkAclEntry> entries;
        private Boolean isDefault;
        private String networkAclId;
        private List<Tag> tags;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAcl model) {
            this.setAssociations(model.associations);
            this.setEntries(model.entries);
            this.setIsDefault(model.isDefault);
            this.setNetworkAclId(model.networkAclId);
            this.setTags(model.tags);
            this.setVpcId(model.vpcId);
        }

        public final Collection<NetworkAclAssociation> getAssociations() {
            return this.associations;
        }

        @Override
        public final Builder associations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(NetworkAclAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
        }

        @SafeVarargs
        public final void setAssociations(NetworkAclAssociation ... associations) {
            this.associations(Arrays.asList(associations));
        }

        public final Collection<NetworkAclEntry> getEntries() {
            return this.entries;
        }

        @Override
        public final Builder entries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(NetworkAclEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(NetworkAclEntry ... entries) {
            this.entries(Arrays.asList(entries));
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public NetworkAcl build() {
            return new NetworkAcl(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkAcl> {
        public Builder associations(Collection<NetworkAclAssociation> var1);

        public Builder associations(NetworkAclAssociation ... var1);

        public Builder entries(Collection<NetworkAclEntry> var1);

        public Builder entries(NetworkAclEntry ... var1);

        public Builder isDefault(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

