/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.EventInformation;
import software.amazon.awssdk.services.ec2.model.EventType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HistoryRecord
implements ToCopyableBuilder<Builder, HistoryRecord> {
    private final EventInformation eventInformation;
    private final String eventType;
    private final Instant timestamp;

    private HistoryRecord(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    public EventInformation eventInformation() {
        return this.eventInformation;
    }

    public String eventType() {
        return this.eventType;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventInformation() == null ? 0 : this.eventInformation().hashCode());
        hashCode = 31 * hashCode + (this.eventType() == null ? 0 : this.eventType().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord other = (HistoryRecord)obj;
        if (other.eventInformation() == null ^ this.eventInformation() == null) {
            return false;
        }
        if (other.eventInformation() != null && !other.eventInformation().equals(this.eventInformation())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        if (other.eventType() != null && !other.eventType().equals(this.eventType())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        return other.timestamp() == null || other.timestamp().equals(this.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventInformation() != null) {
            sb.append("EventInformation: ").append(this.eventInformation()).append(",");
        }
        if (this.eventType() != null) {
            sb.append("EventType: ").append(this.eventType()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private EventInformation eventInformation;
        private String eventType;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecord model) {
            this.setEventInformation(model.eventInformation);
            this.setEventType(model.eventType);
            this.setTimestamp(model.timestamp);
        }

        public final EventInformation getEventInformation() {
            return this.eventInformation;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final void setEventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final void setEventType(EventType eventType) {
            this.eventType(eventType.toString());
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public HistoryRecord build() {
            return new HistoryRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HistoryRecord> {
        public Builder eventInformation(EventInformation var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder timestamp(Instant var1);
    }
}

