/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.FpgaImageState;
import software.amazon.awssdk.services.ec2.model.PciId;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FpgaImage
implements ToCopyableBuilder<Builder, FpgaImage> {
    private final String fpgaImageId;
    private final String fpgaImageGlobalId;
    private final String name;
    private final String description;
    private final String shellVersion;
    private final PciId pciId;
    private final FpgaImageState state;
    private final Instant createTime;
    private final Instant updateTime;
    private final String ownerId;
    private final String ownerAlias;
    private final List<ProductCode> productCodes;
    private final List<Tag> tags;

    private FpgaImage(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
        this.name = builder.name;
        this.description = builder.description;
        this.shellVersion = builder.shellVersion;
        this.pciId = builder.pciId;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.productCodes = builder.productCodes;
        this.tags = builder.tags;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public String fpgaImageGlobalId() {
        return this.fpgaImageGlobalId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String shellVersion() {
        return this.shellVersion;
    }

    public PciId pciId() {
        return this.pciId;
    }

    public FpgaImageState state() {
        return this.state;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fpgaImageId() == null ? 0 : this.fpgaImageId().hashCode());
        hashCode = 31 * hashCode + (this.fpgaImageGlobalId() == null ? 0 : this.fpgaImageGlobalId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.shellVersion() == null ? 0 : this.shellVersion().hashCode());
        hashCode = 31 * hashCode + (this.pciId() == null ? 0 : this.pciId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.createTime() == null ? 0 : this.createTime().hashCode());
        hashCode = 31 * hashCode + (this.updateTime() == null ? 0 : this.updateTime().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.ownerAlias() == null ? 0 : this.ownerAlias().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImage)) {
            return false;
        }
        FpgaImage other = (FpgaImage)obj;
        if (other.fpgaImageId() == null ^ this.fpgaImageId() == null) {
            return false;
        }
        if (other.fpgaImageId() != null && !other.fpgaImageId().equals(this.fpgaImageId())) {
            return false;
        }
        if (other.fpgaImageGlobalId() == null ^ this.fpgaImageGlobalId() == null) {
            return false;
        }
        if (other.fpgaImageGlobalId() != null && !other.fpgaImageGlobalId().equals(this.fpgaImageGlobalId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.shellVersion() == null ^ this.shellVersion() == null) {
            return false;
        }
        if (other.shellVersion() != null && !other.shellVersion().equals(this.shellVersion())) {
            return false;
        }
        if (other.pciId() == null ^ this.pciId() == null) {
            return false;
        }
        if (other.pciId() != null && !other.pciId().equals(this.pciId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.updateTime() == null ^ this.updateTime() == null) {
            return false;
        }
        if (other.updateTime() != null && !other.updateTime().equals(this.updateTime())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.ownerAlias() == null ^ this.ownerAlias() == null) {
            return false;
        }
        if (other.ownerAlias() != null && !other.ownerAlias().equals(this.ownerAlias())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(this.fpgaImageId()).append(",");
        }
        if (this.fpgaImageGlobalId() != null) {
            sb.append("FpgaImageGlobalId: ").append(this.fpgaImageGlobalId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.shellVersion() != null) {
            sb.append("ShellVersion: ").append(this.shellVersion()).append(",");
        }
        if (this.pciId() != null) {
            sb.append("PciId: ").append(this.pciId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.createTime() != null) {
            sb.append("CreateTime: ").append(this.createTime()).append(",");
        }
        if (this.updateTime() != null) {
            sb.append("UpdateTime: ").append(this.updateTime()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.ownerAlias() != null) {
            sb.append("OwnerAlias: ").append(this.ownerAlias()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String fpgaImageGlobalId;
        private String name;
        private String description;
        private String shellVersion;
        private PciId pciId;
        private FpgaImageState state;
        private Instant createTime;
        private Instant updateTime;
        private String ownerId;
        private String ownerAlias;
        private List<ProductCode> productCodes;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImage model) {
            this.setFpgaImageId(model.fpgaImageId);
            this.setFpgaImageGlobalId(model.fpgaImageGlobalId);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setShellVersion(model.shellVersion);
            this.setPciId(model.pciId);
            this.setState(model.state);
            this.setCreateTime(model.createTime);
            this.setUpdateTime(model.updateTime);
            this.setOwnerId(model.ownerId);
            this.setOwnerAlias(model.ownerAlias);
            this.setProductCodes(model.productCodes);
            this.setTags(model.tags);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getFpgaImageGlobalId() {
            return this.fpgaImageGlobalId;
        }

        @Override
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getShellVersion() {
            return this.shellVersion;
        }

        @Override
        public final Builder shellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
            return this;
        }

        public final void setShellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
        }

        public final PciId getPciId() {
            return this.pciId;
        }

        @Override
        public final Builder pciId(PciId pciId) {
            this.pciId = pciId;
            return this;
        }

        public final void setPciId(PciId pciId) {
            this.pciId = pciId;
        }

        public final FpgaImageState getState() {
            return this.state;
        }

        @Override
        public final Builder state(FpgaImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(FpgaImageState state) {
            this.state = state;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public FpgaImage build() {
            return new FpgaImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FpgaImage> {
        public Builder fpgaImageId(String var1);

        public Builder fpgaImageGlobalId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder shellVersion(String var1);

        public Builder pciId(PciId var1);

        public Builder state(FpgaImageState var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder ownerId(String var1);

        public Builder ownerAlias(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

