/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachVolumeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetachVolumeRequest> {
    private final String device;
    private final Boolean force;
    private final String instanceId;
    private final String volumeId;

    private DetachVolumeRequest(BuilderImpl builder) {
        this.device = builder.device;
        this.force = builder.force;
        this.instanceId = builder.instanceId;
        this.volumeId = builder.volumeId;
    }

    public String device() {
        return this.device;
    }

    public Boolean force() {
        return this.force;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.force() == null ? 0 : this.force().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest)((Object)obj);
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.force() == null ^ this.force() == null) {
            return false;
        }
        if (other.force() != null && !other.force().equals(this.force())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        return other.volumeId() == null || other.volumeId().equals(this.volumeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String device;
        private Boolean force;
        private String instanceId;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            this.setDevice(model.device);
            this.setForce(model.force);
            this.setInstanceId(model.instanceId);
            this.setVolumeId(model.volumeId);
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachVolumeRequest> {
        public Builder device(String var1);

        public Builder force(Boolean var1);

        public Builder instanceId(String var1);

        public Builder volumeId(String var1);
    }
}

