/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSecurityGroupsRequest> {
    private final List<Filter> filters;
    private final List<String> groupIds;
    private final List<String> groupNames;

    private DescribeSecurityGroupsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.groupIds() == null ? 0 : this.groupIds().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsRequest)) {
            return false;
        }
        DescribeSecurityGroupsRequest other = (DescribeSecurityGroupsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.groupIds() == null ^ this.groupIds() == null) {
            return false;
        }
        if (other.groupIds() != null && !other.groupIds().equals(this.groupIds())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        return other.groupNames() == null || other.groupNames().equals(this.groupNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.groupIds() != null) {
            sb.append("GroupIds: ").append(this.groupIds()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> groupIds;
        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsRequest model) {
            this.setFilters(model.filters);
            this.setGroupIds(model.groupIds);
            this.setGroupNames(model.groupNames);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getGroupIds() {
            return this.groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = GroupIdStringListCopier.copy(groupIds);
        }

        @SafeVarargs
        public final void setGroupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
        }

        public DescribeSecurityGroupsRequest build() {
            return new DescribeSecurityGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSecurityGroupsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);
    }
}

