/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedInstancesRequest> {
    private final List<Filter> filters;
    private final String offeringClass;
    private final List<String> reservedInstancesIds;
    private final String offeringType;

    private DescribeReservedInstancesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.offeringClass = builder.offeringClass;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.offeringType = builder.offeringType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String offeringClass() {
        return this.offeringClass;
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.offeringClass() == null ? 0 : this.offeringClass().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesIds() == null ? 0 : this.reservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.reservedInstancesIds() == null ^ this.reservedInstancesIds() == null) {
            return false;
        }
        if (other.reservedInstancesIds() != null && !other.reservedInstancesIds().equals(this.reservedInstancesIds())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        return other.offeringType() == null || other.offeringType().equals(this.offeringType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.offeringClass() != null) {
            sb.append("OfferingClass: ").append(this.offeringClass()).append(",");
        }
        if (this.reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.reservedInstancesIds()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private String offeringClass;
        private List<String> reservedInstancesIds;
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesRequest model) {
            this.setFilters(model.filters);
            this.setOfferingClass(model.offeringClass);
            this.setReservedInstancesIds(model.reservedInstancesIds);
            this.setOfferingType(model.offeringType);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final void setOfferingClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
        }

        public final Collection<String> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        @SafeVarargs
        public final void setReservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final void setOfferingType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
        }

        public DescribeReservedInstancesRequest build() {
            return new DescribeReservedInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);
    }
}

