/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.NetworkInterface;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkInterfacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNetworkInterfacesResponse> {
    private final List<NetworkInterface> networkInterfaces;

    private DescribeNetworkInterfacesResponse(BuilderImpl builder) {
        this.networkInterfaces = builder.networkInterfaces;
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesResponse)) {
            return false;
        }
        DescribeNetworkInterfacesResponse other = (DescribeNetworkInterfacesResponse)((Object)obj);
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        return other.networkInterfaces() == null || other.networkInterfaces().equals(this.networkInterfaces());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<NetworkInterface> networkInterfaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesResponse model) {
            this.setNetworkInterfaces(model.networkInterfaces);
        }

        public final Collection<NetworkInterface> getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
        }

        @SafeVarargs
        public final void setNetworkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
        }

        public DescribeNetworkInterfacesResponse build() {
            return new DescribeNetworkInterfacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkInterfacesResponse> {
        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);
    }
}

