/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.HostReservationIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeHostReservationsRequest> {
    private final List<Filter> filter;
    private final List<String> hostReservationIdSet;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeHostReservationsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.hostReservationIdSet = builder.hostReservationIdSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public List<String> hostReservationIdSet() {
        return this.hostReservationIdSet;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.hostReservationIdSet() == null ? 0 : this.hostReservationIdSet().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsRequest)) {
            return false;
        }
        DescribeHostReservationsRequest other = (DescribeHostReservationsRequest)((Object)obj);
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.hostReservationIdSet() == null ^ this.hostReservationIdSet() == null) {
            return false;
        }
        if (other.hostReservationIdSet() != null && !other.hostReservationIdSet().equals(this.hostReservationIdSet())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.hostReservationIdSet() != null) {
            sb.append("HostReservationIdSet: ").append(this.hostReservationIdSet()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filter;
        private List<String> hostReservationIdSet;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsRequest model) {
            this.setFilter(model.filter);
            this.setHostReservationIdSet(model.hostReservationIdSet);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        @SafeVarargs
        public final void setFilter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
        }

        public final Collection<String> getHostReservationIdSet() {
            return this.hostReservationIdSet;
        }

        @Override
        public final Builder hostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationIdSet(String ... hostReservationIdSet) {
            this.hostReservationIdSet(Arrays.asList(hostReservationIdSet));
            return this;
        }

        public final void setHostReservationIdSet(Collection<String> hostReservationIdSet) {
            this.hostReservationIdSet = HostReservationIdSetCopier.copy(hostReservationIdSet);
        }

        @SafeVarargs
        public final void setHostReservationIdSet(String ... hostReservationIdSet) {
            this.hostReservationIdSet(Arrays.asList(hostReservationIdSet));
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeHostReservationsRequest build() {
            return new DescribeHostReservationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostReservationsRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder hostReservationIdSet(Collection<String> var1);

        public Builder hostReservationIdSet(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

