/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.BundleTaskError;
import software.amazon.awssdk.services.ec2.model.BundleTaskState;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BundleTask
implements ToCopyableBuilder<Builder, BundleTask> {
    private final String bundleId;
    private final BundleTaskError bundleTaskError;
    private final String instanceId;
    private final String progress;
    private final Instant startTime;
    private final String state;
    private final Storage storage;
    private final Instant updateTime;

    private BundleTask(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.bundleTaskError = builder.bundleTaskError;
        this.instanceId = builder.instanceId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.storage = builder.storage;
        this.updateTime = builder.updateTime;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public BundleTaskError bundleTaskError() {
        return this.bundleTaskError;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String progress() {
        return this.progress;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public String state() {
        return this.state;
    }

    public Storage storage() {
        return this.storage;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bundleId() == null ? 0 : this.bundleId().hashCode());
        hashCode = 31 * hashCode + (this.bundleTaskError() == null ? 0 : this.bundleTaskError().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.progress() == null ? 0 : this.progress().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.storage() == null ? 0 : this.storage().hashCode());
        hashCode = 31 * hashCode + (this.updateTime() == null ? 0 : this.updateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleTask)) {
            return false;
        }
        BundleTask other = (BundleTask)obj;
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        if (other.bundleTaskError() == null ^ this.bundleTaskError() == null) {
            return false;
        }
        if (other.bundleTaskError() != null && !other.bundleTaskError().equals(this.bundleTaskError())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.storage() == null ^ this.storage() == null) {
            return false;
        }
        if (other.storage() != null && !other.storage().equals(this.storage())) {
            return false;
        }
        if (other.updateTime() == null ^ this.updateTime() == null) {
            return false;
        }
        return other.updateTime() == null || other.updateTime().equals(this.updateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.bundleTaskError() != null) {
            sb.append("BundleTaskError: ").append(this.bundleTaskError()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.progress() != null) {
            sb.append("Progress: ").append(this.progress()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.storage() != null) {
            sb.append("Storage: ").append(this.storage()).append(",");
        }
        if (this.updateTime() != null) {
            sb.append("UpdateTime: ").append(this.updateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private BundleTaskError bundleTaskError;
        private String instanceId;
        private String progress;
        private Instant startTime;
        private String state;
        private Storage storage;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleTask model) {
            this.setBundleId(model.bundleId);
            this.setBundleTaskError(model.bundleTaskError);
            this.setInstanceId(model.instanceId);
            this.setProgress(model.progress);
            this.setStartTime(model.startTime);
            this.setState(model.state);
            this.setStorage(model.storage);
            this.setUpdateTime(model.updateTime);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final BundleTaskError getBundleTaskError() {
            return this.bundleTaskError;
        }

        @Override
        public final Builder bundleTaskError(BundleTaskError bundleTaskError) {
            this.bundleTaskError = bundleTaskError;
            return this;
        }

        public final void setBundleTaskError(BundleTaskError bundleTaskError) {
            this.bundleTaskError = bundleTaskError;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BundleTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(BundleTaskState state) {
            this.state(state.toString());
        }

        public final Storage getStorage() {
            return this.storage;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage storage) {
            this.storage = storage;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public BundleTask build() {
            return new BundleTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BundleTask> {
        public Builder bundleId(String var1);

        public Builder bundleTaskError(BundleTaskError var1);

        public Builder instanceId(String var1);

        public Builder progress(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(BundleTaskState var1);

        public Builder storage(Storage var1);

        public Builder updateTime(Instant var1);
    }
}

