/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;

public class TerminateInstancesRequestMarshaller
implements Marshaller<Request<TerminateInstancesRequest>, TerminateInstancesRequest> {
    public Request<TerminateInstancesRequest> marshall(TerminateInstancesRequest terminateInstancesRequest) {
        if (terminateInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)terminateInstancesRequest, "Ec2Client");
        request.addParameter("Action", "TerminateInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> terminateInstancesRequestInstanceIdsList = terminateInstancesRequest.instanceIds();
        if (!terminateInstancesRequestInstanceIdsList.isEmpty() || !(terminateInstancesRequestInstanceIdsList instanceof SdkAutoConstructList)) {
            int instanceIdsListIndex = 1;
            for (String terminateInstancesRequestInstanceIdsListValue : terminateInstancesRequestInstanceIdsList) {
                if (terminateInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringConversion.fromString((String)terminateInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

