/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification;

public class TargetCapacitySpecificationUnmarshaller
implements Unmarshaller<TargetCapacitySpecification, StaxUnmarshallerContext> {
    private static final TargetCapacitySpecificationUnmarshaller INSTANCE = new TargetCapacitySpecificationUnmarshaller();

    public TargetCapacitySpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetCapacitySpecification.Builder targetCapacitySpecification = TargetCapacitySpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("totalTargetCapacity", targetDepth)) {
                    targetCapacitySpecification.totalTargetCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("onDemandTargetCapacity", targetDepth)) {
                    targetCapacitySpecification.onDemandTargetCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("spotTargetCapacity", targetDepth)) {
                    targetCapacitySpecification.spotTargetCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("defaultTargetCapacityType", targetDepth)) continue;
                targetCapacitySpecification.defaultTargetCapacityType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetCapacitySpecification)targetCapacitySpecification.build();
    }

    public static TargetCapacitySpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

