/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;

public class RequestSpotInstancesRequestMarshaller
implements Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {
    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {
        LaunchSpecification launchSpecification;
        if (requestSpotInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)requestSpotInstancesRequest, "Ec2Client");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestSpotInstancesRequest.availabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup", StringConversion.fromString((String)requestSpotInstancesRequest.availabilityZoneGroup()));
        }
        if (requestSpotInstancesRequest.blockDurationMinutes() != null) {
            request.addParameter("BlockDurationMinutes", StringConversion.fromInteger((Integer)requestSpotInstancesRequest.blockDurationMinutes()));
        }
        if (requestSpotInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)requestSpotInstancesRequest.clientToken()));
        }
        if (requestSpotInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringConversion.fromInteger((Integer)requestSpotInstancesRequest.instanceCount()));
        }
        if (requestSpotInstancesRequest.launchGroup() != null) {
            request.addParameter("LaunchGroup", StringConversion.fromString((String)requestSpotInstancesRequest.launchGroup()));
        }
        if ((launchSpecification = requestSpotInstancesRequest.launchSpecification()) != null) {
            List<String> launchSpecificationSecurityGroupsList;
            List<GroupIdentifier> launchSpecificationAllSecurityGroupsList;
            SpotPlacement placement;
            List<InstanceNetworkInterfaceSpecification> launchSpecificationNetworkInterfacesList;
            IamInstanceProfileSpecification iamInstanceProfile;
            List<BlockDeviceMapping> launchSpecificationBlockDeviceMappingsList;
            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringConversion.fromString((String)launchSpecification.userData()));
            }
            if (launchSpecification.addressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType", StringConversion.fromString((String)launchSpecification.addressingType()));
            }
            if (!(launchSpecificationBlockDeviceMappingsList = launchSpecification.blockDeviceMappings()).isEmpty() || !(launchSpecificationBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
                int blockDeviceMappingsListIndex = 1;
                for (BlockDeviceMapping launchSpecificationBlockDeviceMappingsListValue : launchSpecificationBlockDeviceMappingsList) {
                    Object ebs;
                    if (launchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)launchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)launchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }
                    if ((ebs = launchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                        if (((EbsBlockDevice)ebs).encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)((EbsBlockDevice)ebs).encrypted()));
                        }
                        if (((EbsBlockDevice)ebs).deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)((EbsBlockDevice)ebs).deleteOnTermination()));
                        }
                        if (((EbsBlockDevice)ebs).iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)((EbsBlockDevice)ebs).iops()));
                        }
                        if (((EbsBlockDevice)ebs).kmsKeyId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringConversion.fromString((String)((EbsBlockDevice)ebs).kmsKeyId()));
                        }
                        if (((EbsBlockDevice)ebs).snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)((EbsBlockDevice)ebs).snapshotId()));
                        }
                        if (((EbsBlockDevice)ebs).volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)((EbsBlockDevice)ebs).volumeSize()));
                        }
                        if (((EbsBlockDevice)ebs).volumeTypeAsString() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)((EbsBlockDevice)ebs).volumeTypeAsString()));
                        }
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)launchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringConversion.fromBoolean((Boolean)launchSpecification.ebsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.iamInstanceProfile()) != null) {
                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
                }
                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
                }
            }
            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringConversion.fromString((String)launchSpecification.imageId()));
            }
            if (launchSpecification.instanceTypeAsString() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringConversion.fromString((String)launchSpecification.instanceTypeAsString()));
            }
            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringConversion.fromString((String)launchSpecification.kernelId()));
            }
            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringConversion.fromString((String)launchSpecification.keyName()));
            }
            if (!(launchSpecificationNetworkInterfacesList = launchSpecification.networkInterfaces()).isEmpty() || !(launchSpecificationNetworkInterfacesList instanceof SdkAutoConstructList)) {
                int networkInterfacesListIndex = 1;
                for (InstanceNetworkInterfaceSpecification launchSpecificationNetworkInterfacesListValue : launchSpecificationNetworkInterfacesList) {
                    List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                    List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList;
                    Object instanceNetworkInterfaceSpecificationGroupsList;
                    if (launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringConversion.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringConversion.fromString((String)launchSpecificationNetworkInterfacesListValue.description()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringConversion.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationGroupsList = launchSpecificationNetworkInterfacesListValue.groups()).isEmpty() || !(instanceNetworkInterfaceSpecificationGroupsList instanceof SdkAutoConstructList)) {
                        int groupsListIndex = 1;
                        Iterator iterator = instanceNetworkInterfaceSpecificationGroupsList.iterator();
                        while (iterator.hasNext()) {
                            String instanceNetworkInterfaceSpecificationGroupsListValue = (String)iterator.next();
                            if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringConversion.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringConversion.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = launchSpecificationNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationIpv6AddressesList instanceof SdkAutoConstructList)) {
                        int ipv6AddressesListIndex = 1;
                        for (InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {
                            if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringConversion.fromString((String)launchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)launchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = launchSpecificationNetworkInterfacesListValue.privateIpAddresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationPrivateIpAddressesList instanceof SdkAutoConstructList)) {
                        int privateIpAddressesListIndex = 1;
                        for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringConversion.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                            }
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringConversion.fromString((String)launchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
                }
                if (placement.tenancyAsString() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringConversion.fromString((String)placement.tenancyAsString()));
                }
            }
            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringConversion.fromString((String)launchSpecification.ramdiskId()));
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringConversion.fromString((String)launchSpecification.subnetId()));
            }
            if (!(launchSpecificationAllSecurityGroupsList = launchSpecification.allSecurityGroups()).isEmpty() || !(launchSpecificationAllSecurityGroupsList instanceof SdkAutoConstructList)) {
                int allSecurityGroupsListIndex = 1;
                for (GroupIdentifier launchSpecificationAllSecurityGroupsListValue : launchSpecificationAllSecurityGroupsList) {
                    if (launchSpecificationAllSecurityGroupsListValue.groupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName", StringConversion.fromString((String)launchSpecificationAllSecurityGroupsListValue.groupName()));
                    }
                    if (launchSpecificationAllSecurityGroupsListValue.groupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId", StringConversion.fromString((String)launchSpecificationAllSecurityGroupsListValue.groupId()));
                    }
                    ++allSecurityGroupsListIndex;
                }
            }
            if (launchSpecification.monitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringConversion.fromBoolean((Boolean)launchSpecification.monitoringEnabled()));
            }
            if (!(launchSpecificationSecurityGroupsList = launchSpecification.securityGroups()).isEmpty() || !(launchSpecificationSecurityGroupsList instanceof SdkAutoConstructList)) {
                int securityGroupsListIndex = 1;
                for (String launchSpecificationSecurityGroupsListValue : launchSpecificationSecurityGroupsList) {
                    if (launchSpecificationSecurityGroupsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex, StringConversion.fromString((String)launchSpecificationSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (requestSpotInstancesRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringConversion.fromString((String)requestSpotInstancesRequest.spotPrice()));
        }
        if (requestSpotInstancesRequest.typeAsString() != null) {
            request.addParameter("Type", StringConversion.fromString((String)requestSpotInstancesRequest.typeAsString()));
        }
        if (requestSpotInstancesRequest.validFrom() != null) {
            request.addParameter("ValidFrom", StringConversion.fromInstant((Instant)requestSpotInstancesRequest.validFrom()));
        }
        if (requestSpotInstancesRequest.validUntil() != null) {
            request.addParameter("ValidUntil", StringConversion.fromInstant((Instant)requestSpotInstancesRequest.validUntil()));
        }
        if (requestSpotInstancesRequest.instanceInterruptionBehaviorAsString() != null) {
            request.addParameter("InstanceInterruptionBehavior", StringConversion.fromString((String)requestSpotInstancesRequest.instanceInterruptionBehaviorAsString()));
        }
        return request;
    }
}

