/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;

public class ModifyLaunchTemplateRequestMarshaller
implements Marshaller<Request<ModifyLaunchTemplateRequest>, ModifyLaunchTemplateRequest> {
    public Request<ModifyLaunchTemplateRequest> marshall(ModifyLaunchTemplateRequest modifyLaunchTemplateRequest) {
        if (modifyLaunchTemplateRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyLaunchTemplateRequest, "Ec2Client");
        request.addParameter("Action", "ModifyLaunchTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLaunchTemplateRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)modifyLaunchTemplateRequest.clientToken()));
        }
        if (modifyLaunchTemplateRequest.launchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringConversion.fromString((String)modifyLaunchTemplateRequest.launchTemplateId()));
        }
        if (modifyLaunchTemplateRequest.launchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringConversion.fromString((String)modifyLaunchTemplateRequest.launchTemplateName()));
        }
        if (modifyLaunchTemplateRequest.defaultVersion() != null) {
            request.addParameter("SetDefaultVersion", StringConversion.fromString((String)modifyLaunchTemplateRequest.defaultVersion()));
        }
        return request;
    }
}

