/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.services.ec2.transform.ResponseLaunchTemplateDataUnmarshaller;

public class LaunchTemplateVersionUnmarshaller
implements Unmarshaller<LaunchTemplateVersion, StaxUnmarshallerContext> {
    private static final LaunchTemplateVersionUnmarshaller INSTANCE = new LaunchTemplateVersionUnmarshaller();

    public LaunchTemplateVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LaunchTemplateVersion.Builder launchTemplateVersion = LaunchTemplateVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("launchTemplateId", targetDepth)) {
                    launchTemplateVersion.launchTemplateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("launchTemplateName", targetDepth)) {
                    launchTemplateVersion.launchTemplateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("versionNumber", targetDepth)) {
                    launchTemplateVersion.versionNumber(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("versionDescription", targetDepth)) {
                    launchTemplateVersion.versionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createTime", targetDepth)) {
                    launchTemplateVersion.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createdBy", targetDepth)) {
                    launchTemplateVersion.createdBy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultVersion", targetDepth)) {
                    launchTemplateVersion.defaultVersion(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("launchTemplateData", targetDepth)) continue;
                launchTemplateVersion.launchTemplateData(ResponseLaunchTemplateDataUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LaunchTemplateVersion)launchTemplateVersion.build();
    }

    public static LaunchTemplateVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

