/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.UserBucket;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        List<ImageDiskContainer> importImageRequestDiskContainersList;
        ClientData clientData;
        if (importImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)importImageRequest, "Ec2Client");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importImageRequest.architecture() != null) {
            request.addParameter("Architecture", StringConversion.fromString((String)importImageRequest.architecture()));
        }
        if ((clientData = importImageRequest.clientData()) != null) {
            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringConversion.fromString((String)clientData.comment()));
            }
            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringConversion.fromInstant((Instant)clientData.uploadEnd()));
            }
            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringConversion.fromDouble((Double)clientData.uploadSize()));
            }
            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringConversion.fromInstant((Instant)clientData.uploadStart()));
            }
        }
        if (importImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)importImageRequest.clientToken()));
        }
        if (importImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)importImageRequest.description()));
        }
        if (!(importImageRequestDiskContainersList = importImageRequest.diskContainers()).isEmpty() || !(importImageRequestDiskContainersList instanceof SdkAutoConstructList)) {
            int diskContainersListIndex = 1;
            for (ImageDiskContainer importImageRequestDiskContainersListValue : importImageRequestDiskContainersList) {
                UserBucket userBucket;
                if (importImageRequestDiskContainersListValue.description() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringConversion.fromString((String)importImageRequestDiskContainersListValue.description()));
                }
                if (importImageRequestDiskContainersListValue.deviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringConversion.fromString((String)importImageRequestDiskContainersListValue.deviceName()));
                }
                if (importImageRequestDiskContainersListValue.format() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringConversion.fromString((String)importImageRequestDiskContainersListValue.format()));
                }
                if (importImageRequestDiskContainersListValue.snapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringConversion.fromString((String)importImageRequestDiskContainersListValue.snapshotId()));
                }
                if (importImageRequestDiskContainersListValue.url() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringConversion.fromString((String)importImageRequestDiskContainersListValue.url()));
                }
                if ((userBucket = importImageRequestDiskContainersListValue.userBucket()) != null) {
                    if (userBucket.s3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringConversion.fromString((String)userBucket.s3Bucket()));
                    }
                    if (userBucket.s3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringConversion.fromString((String)userBucket.s3Key()));
                    }
                }
                ++diskContainersListIndex;
            }
        }
        if (importImageRequest.hypervisor() != null) {
            request.addParameter("Hypervisor", StringConversion.fromString((String)importImageRequest.hypervisor()));
        }
        if (importImageRequest.licenseType() != null) {
            request.addParameter("LicenseType", StringConversion.fromString((String)importImageRequest.licenseType()));
        }
        if (importImageRequest.platform() != null) {
            request.addParameter("Platform", StringConversion.fromString((String)importImageRequest.platform()));
        }
        if (importImageRequest.roleName() != null) {
            request.addParameter("RoleName", StringConversion.fromString((String)importImageRequest.roleName()));
        }
        return request;
    }
}

