/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkProtectedApi
public final class Ec2Interceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        ModifyReservedInstancesRequest modifyReservedInstancesRequest;
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        if (originalRequest instanceof ImportKeyPairRequest) {
            ImportKeyPairRequest importKeyPairRequest = (ImportKeyPairRequest)originalRequest;
            String publicKeyMaterial = importKeyPairRequest.publicKeyMaterial();
            String encodedKeyMaterial = BinaryUtils.toBase64((byte[])publicKeyMaterial.getBytes(StandardCharsets.UTF_8));
            mutableRequest.putRawQueryParameter("PublicKeyMaterial", encodedKeyMaterial);
        } else if (originalRequest instanceof RequestSpotInstancesRequest) {
            RequestSpotInstancesRequest requestSpotInstancesRequest = (RequestSpotInstancesRequest)originalRequest;
            int groupNameCount = 1;
            for (String groupName : requestSpotInstancesRequest.launchSpecification().securityGroups()) {
                mutableRequest.putRawQueryParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, groupName);
            }
            int groupIdCount = 1;
            for (GroupIdentifier group : requestSpotInstancesRequest.launchSpecification().allSecurityGroups()) {
                if (group.groupId() != null) {
                    mutableRequest.putRawQueryParameter("LaunchSpecification.SecurityGroupId." + groupIdCount++, group.groupId());
                }
                if (group.groupName() == null) continue;
                mutableRequest.putRawQueryParameter("LaunchSpecification.SecurityGroup." + groupNameCount++, group.groupName());
            }
            request.rawQueryParameters().keySet().stream().filter(parameter -> parameter.startsWith("LaunchSpecification.GroupSet.")).forEach(arg_0 -> ((SdkHttpFullRequest.Builder)mutableRequest).removeQueryParameter(arg_0));
        } else if (originalRequest instanceof RunInstancesRequest) {
            RunInstancesRequest runInstancesRequest = (RunInstancesRequest)originalRequest;
            if (runInstancesRequest.clientToken() == null) {
                mutableRequest.putRawQueryParameter("ClientToken", UUID.randomUUID().toString());
            }
        } else if (originalRequest instanceof ModifyReservedInstancesRequest && (modifyReservedInstancesRequest = (ModifyReservedInstancesRequest)originalRequest).clientToken() == null) {
            mutableRequest.putRawQueryParameter("ClientToken", UUID.randomUUID().toString());
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse awsResponse = context.response();
        if (awsResponse instanceof DescribeSpotInstanceRequestsResponse) {
            return this.convertDescribeSpotInstanceRequestsResponse((DescribeSpotInstanceRequestsResponse)awsResponse);
        }
        if (awsResponse instanceof RequestSpotInstancesResponse) {
            return this.convertRequestSpotInstancesResponse((RequestSpotInstancesResponse)awsResponse);
        }
        if (awsResponse instanceof DescribeInstancesResponse) {
            return this.convertDescribeInstancesResponse((DescribeInstancesResponse)awsResponse);
        }
        if (awsResponse instanceof RunInstancesResponse) {
            return this.convertRunInstanceResponse((RunInstancesResponse)awsResponse);
        }
        return awsResponse;
    }

    private DescribeSpotInstanceRequestsResponse convertDescribeSpotInstanceRequestsResponse(DescribeSpotInstanceRequestsResponse response) {
        DescribeSpotInstanceRequestsResponse.Builder responseBuilder = response.toBuilder();
        responseBuilder.spotInstanceRequests(this.convertSpotInstanceRequests(response.spotInstanceRequests()));
        return (DescribeSpotInstanceRequestsResponse)((Object)responseBuilder.build());
    }

    private RequestSpotInstancesResponse convertRequestSpotInstancesResponse(RequestSpotInstancesResponse response) {
        RequestSpotInstancesResponse.Builder responseBuilder = response.toBuilder();
        responseBuilder.spotInstanceRequests(this.convertSpotInstanceRequests(response.spotInstanceRequests()));
        return (RequestSpotInstancesResponse)((Object)responseBuilder.build());
    }

    private DescribeInstancesResponse convertDescribeInstancesResponse(DescribeInstancesResponse response) {
        DescribeInstancesResponse.Builder responseBuilder = response.toBuilder();
        responseBuilder.reservations(this.convertReservation(response.reservations()));
        return (DescribeInstancesResponse)((Object)responseBuilder.build());
    }

    private RunInstancesResponse convertRunInstanceResponse(RunInstancesResponse response) {
        RunInstancesResponse.Builder responseBuilder = response.toBuilder();
        responseBuilder.reservation(this.convertReservationSecurityGroupNames(response.reservation()));
        return (RunInstancesResponse)((Object)responseBuilder.build());
    }

    private List<Reservation> convertReservation(List<Reservation> reservations) {
        return reservations.stream().map(this::convertReservationSecurityGroupNames).collect(Collectors.toList());
    }

    private Reservation convertReservationSecurityGroupNames(Reservation reservation) {
        Reservation.Builder builder = reservation.toBuilder();
        builder.groupNames(reservation.groups().stream().map(GroupIdentifier::groupName).collect(Collectors.toList()));
        return (Reservation)builder.build();
    }

    private List<SpotInstanceRequest> convertSpotInstanceRequests(List<SpotInstanceRequest> spotInstanceRequests) {
        return spotInstanceRequests.stream().map(this::convertSpotInstanceRequest).collect(Collectors.toList());
    }

    private SpotInstanceRequest convertSpotInstanceRequest(SpotInstanceRequest spotInstanceRequest) {
        SpotInstanceRequest.Builder spotInstanceRequestBuilder = spotInstanceRequest.toBuilder();
        LaunchSpecification launchSpecification = spotInstanceRequest.launchSpecification();
        LaunchSpecification.Builder launchSpecificationBuilder = launchSpecification.toBuilder();
        launchSpecificationBuilder.securityGroups(this.convertSpecificationSecurityGroupNames(launchSpecification));
        spotInstanceRequestBuilder.launchSpecification((LaunchSpecification)launchSpecificationBuilder.build());
        return (SpotInstanceRequest)spotInstanceRequestBuilder.build();
    }

    private List<String> convertSpecificationSecurityGroupNames(LaunchSpecification launchSpecification) {
        return launchSpecification.allSecurityGroups().stream().map(GroupIdentifier::groupName).collect(Collectors.toList());
    }
}

