/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;

public class DetachVpnGatewayRequestMarshaller
implements Marshaller<Request<DetachVpnGatewayRequest>, DetachVpnGatewayRequest> {
    public Request<DetachVpnGatewayRequest> marshall(DetachVpnGatewayRequest detachVpnGatewayRequest) {
        if (detachVpnGatewayRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachVpnGatewayRequest, "Ec2Client");
        request.addParameter("Action", "DetachVpnGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachVpnGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)detachVpnGatewayRequest.vpcId()));
        }
        if (detachVpnGatewayRequest.vpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringConversion.fromString((String)detachVpnGatewayRequest.vpnGatewayId()));
        }
        return request;
    }
}

