/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;

public class DetachVolumeRequestMarshaller
implements Marshaller<Request<DetachVolumeRequest>, DetachVolumeRequest> {
    public Request<DetachVolumeRequest> marshall(DetachVolumeRequest detachVolumeRequest) {
        if (detachVolumeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachVolumeRequest, "Ec2Client");
        request.addParameter("Action", "DetachVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachVolumeRequest.device() != null) {
            request.addParameter("Device", StringConversion.fromString((String)detachVolumeRequest.device()));
        }
        if (detachVolumeRequest.force() != null) {
            request.addParameter("Force", StringConversion.fromBoolean((Boolean)detachVolumeRequest.force()));
        }
        if (detachVolumeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)detachVolumeRequest.instanceId()));
        }
        if (detachVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)detachVolumeRequest.volumeId()));
        }
        return request;
    }
}

