/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;

public class DetachClassicLinkVpcRequestMarshaller
implements Marshaller<Request<DetachClassicLinkVpcRequest>, DetachClassicLinkVpcRequest> {
    public Request<DetachClassicLinkVpcRequest> marshall(DetachClassicLinkVpcRequest detachClassicLinkVpcRequest) {
        if (detachClassicLinkVpcRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachClassicLinkVpcRequest, "Ec2Client");
        request.addParameter("Action", "DetachClassicLinkVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachClassicLinkVpcRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)detachClassicLinkVpcRequest.instanceId()));
        }
        if (detachClassicLinkVpcRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)detachClassicLinkVpcRequest.vpcId()));
        }
        return request;
    }
}

