/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointServiceConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServiceConfigurationsRequest>, DescribeVpcEndpointServiceConfigurationsRequest> {
    public Request<DescribeVpcEndpointServiceConfigurationsRequest> marshall(DescribeVpcEndpointServiceConfigurationsRequest describeVpcEndpointServiceConfigurationsRequest) {
        List<Filter> describeVpcEndpointServiceConfigurationsRequestFiltersList;
        if (describeVpcEndpointServiceConfigurationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointServiceConfigurationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpointServiceConfigurations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeVpcEndpointServiceConfigurationsRequestServiceIdsList = describeVpcEndpointServiceConfigurationsRequest.serviceIds();
        if (!describeVpcEndpointServiceConfigurationsRequestServiceIdsList.isEmpty() || !(describeVpcEndpointServiceConfigurationsRequestServiceIdsList instanceof SdkAutoConstructList)) {
            int serviceIdsListIndex = 1;
            for (String describeVpcEndpointServiceConfigurationsRequestServiceIdsListValue : describeVpcEndpointServiceConfigurationsRequestServiceIdsList) {
                if (describeVpcEndpointServiceConfigurationsRequestServiceIdsListValue != null) {
                    request.addParameter("ServiceId." + serviceIdsListIndex, StringConversion.fromString((String)describeVpcEndpointServiceConfigurationsRequestServiceIdsListValue));
                }
                ++serviceIdsListIndex;
            }
        }
        if (!(describeVpcEndpointServiceConfigurationsRequestFiltersList = describeVpcEndpointServiceConfigurationsRequest.filters()).isEmpty() || !(describeVpcEndpointServiceConfigurationsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServiceConfigurationsRequestFiltersListValue : describeVpcEndpointServiceConfigurationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointServiceConfigurationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointServiceConfigurationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointServiceConfigurationsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServiceConfigurationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointServiceConfigurationsRequest.maxResults()));
        }
        if (describeVpcEndpointServiceConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointServiceConfigurationsRequest.nextToken()));
        }
        return request;
    }
}

