/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointConnectionsRequest>, DescribeVpcEndpointConnectionsRequest> {
    public Request<DescribeVpcEndpointConnectionsRequest> marshall(DescribeVpcEndpointConnectionsRequest describeVpcEndpointConnectionsRequest) {
        if (describeVpcEndpointConnectionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointConnectionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpointConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpcEndpointConnectionsRequestFiltersList = describeVpcEndpointConnectionsRequest.filters();
        if (!describeVpcEndpointConnectionsRequestFiltersList.isEmpty() || !(describeVpcEndpointConnectionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointConnectionsRequestFiltersListValue : describeVpcEndpointConnectionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointConnectionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointConnectionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointConnectionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointConnectionsRequest.maxResults()));
        }
        if (describeVpcEndpointConnectionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointConnectionsRequest.nextToken()));
        }
        return request;
    }
}

