/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointConnectionNotificationsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointConnectionNotificationsRequest>, DescribeVpcEndpointConnectionNotificationsRequest> {
    public Request<DescribeVpcEndpointConnectionNotificationsRequest> marshall(DescribeVpcEndpointConnectionNotificationsRequest describeVpcEndpointConnectionNotificationsRequest) {
        List<Filter> describeVpcEndpointConnectionNotificationsRequestFiltersList;
        if (describeVpcEndpointConnectionNotificationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointConnectionNotificationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpointConnectionNotifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcEndpointConnectionNotificationsRequest.connectionNotificationId() != null) {
            request.addParameter("ConnectionNotificationId", StringConversion.fromString((String)describeVpcEndpointConnectionNotificationsRequest.connectionNotificationId()));
        }
        if (!(describeVpcEndpointConnectionNotificationsRequestFiltersList = describeVpcEndpointConnectionNotificationsRequest.filters()).isEmpty() || !(describeVpcEndpointConnectionNotificationsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointConnectionNotificationsRequestFiltersListValue : describeVpcEndpointConnectionNotificationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointConnectionNotificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointConnectionNotificationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointConnectionNotificationsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointConnectionNotificationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointConnectionNotificationsRequest.maxResults()));
        }
        if (describeVpcEndpointConnectionNotificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointConnectionNotificationsRequest.nextToken()));
        }
        return request;
    }
}

