/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest;

public class DescribeScheduledInstanceAvailabilityRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstanceAvailabilityRequest>, DescribeScheduledInstanceAvailabilityRequest> {
    public Request<DescribeScheduledInstanceAvailabilityRequest> marshall(DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        ScheduledInstanceRecurrenceRequest recurrence;
        SlotDateTimeRangeRequest firstSlotStartTimeRange;
        if (describeScheduledInstanceAvailabilityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeScheduledInstanceAvailabilityRequest, "Ec2Client");
        request.addParameter("Action", "DescribeScheduledInstanceAvailability");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeScheduledInstanceAvailabilityRequestFiltersList = describeScheduledInstanceAvailabilityRequest.filters();
        if (!describeScheduledInstanceAvailabilityRequestFiltersList.isEmpty() || !(describeScheduledInstanceAvailabilityRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeScheduledInstanceAvailabilityRequestFiltersListValue : describeScheduledInstanceAvailabilityRequestFiltersList) {
                List<String> filterValuesList;
                if (describeScheduledInstanceAvailabilityRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeScheduledInstanceAvailabilityRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeScheduledInstanceAvailabilityRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((firstSlotStartTimeRange = describeScheduledInstanceAvailabilityRequest.firstSlotStartTimeRange()) != null) {
            if (firstSlotStartTimeRange.earliestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.EarliestTime", StringConversion.fromInstant((Instant)firstSlotStartTimeRange.earliestTime()));
            }
            if (firstSlotStartTimeRange.latestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.LatestTime", StringConversion.fromInstant((Instant)firstSlotStartTimeRange.latestTime()));
            }
        }
        if (describeScheduledInstanceAvailabilityRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.maxResults()));
        }
        if (describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours() != null) {
            request.addParameter("MaxSlotDurationInHours", StringConversion.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours() != null) {
            request.addParameter("MinSlotDurationInHours", StringConversion.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeScheduledInstanceAvailabilityRequest.nextToken()));
        }
        if ((recurrence = describeScheduledInstanceAvailabilityRequest.recurrence()) != null) {
            List<Integer> scheduledInstanceRecurrenceRequestOccurrenceDaysList;
            if (recurrence.frequency() != null) {
                request.addParameter("Recurrence.Frequency", StringConversion.fromString((String)recurrence.frequency()));
            }
            if (recurrence.interval() != null) {
                request.addParameter("Recurrence.Interval", StringConversion.fromInteger((Integer)recurrence.interval()));
            }
            if (!(scheduledInstanceRecurrenceRequestOccurrenceDaysList = recurrence.occurrenceDays()).isEmpty() || !(scheduledInstanceRecurrenceRequestOccurrenceDaysList instanceof SdkAutoConstructList)) {
                int occurrenceDaysListIndex = 1;
                for (Integer scheduledInstanceRecurrenceRequestOccurrenceDaysListValue : scheduledInstanceRecurrenceRequestOccurrenceDaysList) {
                    if (scheduledInstanceRecurrenceRequestOccurrenceDaysListValue != null) {
                        request.addParameter("Recurrence.OccurrenceDay." + occurrenceDaysListIndex, StringConversion.fromInteger((Integer)scheduledInstanceRecurrenceRequestOccurrenceDaysListValue));
                    }
                    ++occurrenceDaysListIndex;
                }
            }
            if (recurrence.occurrenceRelativeToEnd() != null) {
                request.addParameter("Recurrence.OccurrenceRelativeToEnd", StringConversion.fromBoolean((Boolean)recurrence.occurrenceRelativeToEnd()));
            }
            if (recurrence.occurrenceUnit() != null) {
                request.addParameter("Recurrence.OccurrenceUnit", StringConversion.fromString((String)recurrence.occurrenceUnit()));
            }
        }
        return request;
    }
}

