/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeReservedInstancesRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesRequest>, DescribeReservedInstancesRequest> {
    public Request<DescribeReservedInstancesRequest> marshall(DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        List<String> describeReservedInstancesRequestReservedInstancesIdsList;
        if (describeReservedInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedInstancesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeReservedInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeReservedInstancesRequestFiltersList = describeReservedInstancesRequest.filters();
        if (!describeReservedInstancesRequestFiltersList.isEmpty() || !(describeReservedInstancesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesRequestFiltersListValue : describeReservedInstancesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeReservedInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeReservedInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeReservedInstancesRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesRequest.offeringClassAsString() != null) {
            request.addParameter("OfferingClass", StringConversion.fromString((String)describeReservedInstancesRequest.offeringClassAsString()));
        }
        if (!(describeReservedInstancesRequestReservedInstancesIdsList = describeReservedInstancesRequest.reservedInstancesIds()).isEmpty() || !(describeReservedInstancesRequestReservedInstancesIdsList instanceof SdkAutoConstructList)) {
            int reservedInstancesIdsListIndex = 1;
            for (String describeReservedInstancesRequestReservedInstancesIdsListValue : describeReservedInstancesRequestReservedInstancesIdsList) {
                if (describeReservedInstancesRequestReservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringConversion.fromString((String)describeReservedInstancesRequestReservedInstancesIdsListValue));
                }
                ++reservedInstancesIdsListIndex;
            }
        }
        if (describeReservedInstancesRequest.offeringTypeAsString() != null) {
            request.addParameter("OfferingType", StringConversion.fromString((String)describeReservedInstancesRequest.offeringTypeAsString()));
        }
        return request;
    }
}

