/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        List<String> list;
        List<String> describeImagesRequestImageIdsList;
        List<Filter> describeImagesRequestFiltersList;
        if (describeImagesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeImagesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeImagesRequestExecutableUsersList = describeImagesRequest.executableUsers();
        if (!describeImagesRequestExecutableUsersList.isEmpty() || !(describeImagesRequestExecutableUsersList instanceof SdkAutoConstructList)) {
            int executableUsersListIndex = 1;
            for (String string : describeImagesRequestExecutableUsersList) {
                if (string != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringConversion.fromString((String)string));
                }
                ++executableUsersListIndex;
            }
        }
        if (!(describeImagesRequestFiltersList = describeImagesRequest.filters()).isEmpty() || !(describeImagesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter filter : describeImagesRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filter.name()));
                }
                if (!(filterValuesList = filter.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImagesRequestImageIdsList = describeImagesRequest.imageIds()).isEmpty() || !(describeImagesRequestImageIdsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeImagesRequestImageIdsListValue : describeImagesRequestImageIdsList) {
                void var6_12;
                if (describeImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + (int)var6_12, StringConversion.fromString((String)describeImagesRequestImageIdsListValue));
                }
                ++var6_12;
            }
        }
        if (!(list = describeImagesRequest.owners()).isEmpty() || !(list instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeImagesRequestOwnersListValue : list) {
                void var7_18;
                if (describeImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + (int)var7_18, StringConversion.fromString((String)describeImagesRequestOwnersListValue));
                }
                ++var7_18;
            }
        }
        return request;
    }
}

