/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeIamInstanceProfileAssociationsRequestMarshaller
implements Marshaller<Request<DescribeIamInstanceProfileAssociationsRequest>, DescribeIamInstanceProfileAssociationsRequest> {
    public Request<DescribeIamInstanceProfileAssociationsRequest> marshall(DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {
        List<Filter> describeIamInstanceProfileAssociationsRequestFiltersList;
        if (describeIamInstanceProfileAssociationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeIamInstanceProfileAssociationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeIamInstanceProfileAssociations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeIamInstanceProfileAssociationsRequestAssociationIdsList = describeIamInstanceProfileAssociationsRequest.associationIds();
        if (!describeIamInstanceProfileAssociationsRequestAssociationIdsList.isEmpty() || !(describeIamInstanceProfileAssociationsRequestAssociationIdsList instanceof SdkAutoConstructList)) {
            int associationIdsListIndex = 1;
            for (String describeIamInstanceProfileAssociationsRequestAssociationIdsListValue : describeIamInstanceProfileAssociationsRequestAssociationIdsList) {
                if (describeIamInstanceProfileAssociationsRequestAssociationIdsListValue != null) {
                    request.addParameter("AssociationId." + associationIdsListIndex, StringConversion.fromString((String)describeIamInstanceProfileAssociationsRequestAssociationIdsListValue));
                }
                ++associationIdsListIndex;
            }
        }
        if (!(describeIamInstanceProfileAssociationsRequestFiltersList = describeIamInstanceProfileAssociationsRequest.filters()).isEmpty() || !(describeIamInstanceProfileAssociationsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeIamInstanceProfileAssociationsRequestFiltersListValue : describeIamInstanceProfileAssociationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeIamInstanceProfileAssociationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeIamInstanceProfileAssociationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeIamInstanceProfileAssociationsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIamInstanceProfileAssociationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeIamInstanceProfileAssociationsRequest.maxResults()));
        }
        if (describeIamInstanceProfileAssociationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeIamInstanceProfileAssociationsRequest.nextToken()));
        }
        return request;
    }
}

