/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeFleetsRequestMarshaller
implements Marshaller<Request<DescribeFleetsRequest>, DescribeFleetsRequest> {
    public Request<DescribeFleetsRequest> marshall(DescribeFleetsRequest describeFleetsRequest) {
        List<Filter> describeFleetsRequestFiltersList;
        List<String> describeFleetsRequestFleetIdsList;
        if (describeFleetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeFleetsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeFleets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeFleetsRequest.maxResults()));
        }
        if (describeFleetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeFleetsRequest.nextToken()));
        }
        if (!(describeFleetsRequestFleetIdsList = describeFleetsRequest.fleetIds()).isEmpty() || !(describeFleetsRequestFleetIdsList instanceof SdkAutoConstructList)) {
            int fleetIdsListIndex = 1;
            for (String describeFleetsRequestFleetIdsListValue : describeFleetsRequestFleetIdsList) {
                if (describeFleetsRequestFleetIdsListValue != null) {
                    request.addParameter("FleetId." + fleetIdsListIndex, StringConversion.fromString((String)describeFleetsRequestFleetIdsListValue));
                }
                ++fleetIdsListIndex;
            }
        }
        if (!(describeFleetsRequestFiltersList = describeFleetsRequest.filters()).isEmpty() || !(describeFleetsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeFleetsRequestFiltersListValue : describeFleetsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeFleetsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeFleetsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeFleetsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

