/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;

public class DescribeConversionTasksRequestMarshaller
implements Marshaller<Request<DescribeConversionTasksRequest>, DescribeConversionTasksRequest> {
    public Request<DescribeConversionTasksRequest> marshall(DescribeConversionTasksRequest describeConversionTasksRequest) {
        if (describeConversionTasksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeConversionTasksRequest, "Ec2Client");
        request.addParameter("Action", "DescribeConversionTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeConversionTasksRequestConversionTaskIdsList = describeConversionTasksRequest.conversionTaskIds();
        if (!describeConversionTasksRequestConversionTaskIdsList.isEmpty() || !(describeConversionTasksRequestConversionTaskIdsList instanceof SdkAutoConstructList)) {
            int conversionTaskIdsListIndex = 1;
            for (String describeConversionTasksRequestConversionTaskIdsListValue : describeConversionTasksRequestConversionTaskIdsList) {
                if (describeConversionTasksRequestConversionTaskIdsListValue != null) {
                    request.addParameter("ConversionTaskId." + conversionTaskIdsListIndex, StringConversion.fromString((String)describeConversionTasksRequestConversionTaskIdsListValue));
                }
                ++conversionTaskIdsListIndex;
            }
        }
        return request;
    }
}

