/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        List<String> describeAddressesRequestAllocationIdsList;
        List<String> describeAddressesRequestPublicIpsList;
        if (describeAddressesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAddressesRequest, "Ec2Client");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeAddressesRequestFiltersList = describeAddressesRequest.filters();
        if (!describeAddressesRequestFiltersList.isEmpty() || !(describeAddressesRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter filter : describeAddressesRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filter.name()));
                }
                if (!(filterValuesList = filter.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeAddressesRequestPublicIpsList = describeAddressesRequest.publicIps()).isEmpty() || !(describeAddressesRequestPublicIpsList instanceof SdkAutoConstructList)) {
            int publicIpsListIndex = 1;
            for (String describeAddressesRequestPublicIpsListValue : describeAddressesRequestPublicIpsList) {
                if (describeAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringConversion.fromString((String)describeAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if (!(describeAddressesRequestAllocationIdsList = describeAddressesRequest.allocationIds()).isEmpty() || !(describeAddressesRequestAllocationIdsList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String describeAddressesRequestAllocationIdsListValue : describeAddressesRequestAllocationIdsList) {
                void var6_12;
                if (describeAddressesRequestAllocationIdsListValue != null) {
                    request.addParameter("AllocationId." + (int)var6_12, StringConversion.fromString((String)describeAddressesRequestAllocationIdsListValue));
                }
                ++var6_12;
            }
        }
        return request;
    }
}

