/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;

public class DeleteFlowLogsRequestMarshaller
implements Marshaller<Request<DeleteFlowLogsRequest>, DeleteFlowLogsRequest> {
    public Request<DeleteFlowLogsRequest> marshall(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        if (deleteFlowLogsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteFlowLogsRequest, "Ec2Client");
        request.addParameter("Action", "DeleteFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteFlowLogsRequestFlowLogIdsList = deleteFlowLogsRequest.flowLogIds();
        if (!deleteFlowLogsRequestFlowLogIdsList.isEmpty() || !(deleteFlowLogsRequestFlowLogIdsList instanceof SdkAutoConstructList)) {
            int flowLogIdsListIndex = 1;
            for (String deleteFlowLogsRequestFlowLogIdsListValue : deleteFlowLogsRequestFlowLogIdsList) {
                if (deleteFlowLogsRequestFlowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringConversion.fromString((String)deleteFlowLogsRequestFlowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        return request;
    }
}

