/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.CreditSpecification;

public class CreditSpecificationUnmarshaller
implements Unmarshaller<CreditSpecification, StaxUnmarshallerContext> {
    private static final CreditSpecificationUnmarshaller INSTANCE = new CreditSpecificationUnmarshaller();

    public CreditSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CreditSpecification.Builder creditSpecification = CreditSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("cpuCredits", targetDepth)) continue;
                creditSpecification.cpuCredits(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CreditSpecification)creditSpecification.build();
    }

    public static CreditSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

