/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;

public class CreateVpcEndpointConnectionNotificationRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointConnectionNotificationRequest>, CreateVpcEndpointConnectionNotificationRequest> {
    public Request<CreateVpcEndpointConnectionNotificationRequest> marshall(CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest) {
        List<String> createVpcEndpointConnectionNotificationRequestConnectionEventsList;
        if (createVpcEndpointConnectionNotificationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcEndpointConnectionNotificationRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpcEndpointConnectionNotification");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointConnectionNotificationRequest.serviceId() != null) {
            request.addParameter("ServiceId", StringConversion.fromString((String)createVpcEndpointConnectionNotificationRequest.serviceId()));
        }
        if (createVpcEndpointConnectionNotificationRequest.vpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringConversion.fromString((String)createVpcEndpointConnectionNotificationRequest.vpcEndpointId()));
        }
        if (createVpcEndpointConnectionNotificationRequest.connectionNotificationArn() != null) {
            request.addParameter("ConnectionNotificationArn", StringConversion.fromString((String)createVpcEndpointConnectionNotificationRequest.connectionNotificationArn()));
        }
        if (!(createVpcEndpointConnectionNotificationRequestConnectionEventsList = createVpcEndpointConnectionNotificationRequest.connectionEvents()).isEmpty() || !(createVpcEndpointConnectionNotificationRequestConnectionEventsList instanceof SdkAutoConstructList)) {
            int connectionEventsListIndex = 1;
            for (String createVpcEndpointConnectionNotificationRequestConnectionEventsListValue : createVpcEndpointConnectionNotificationRequestConnectionEventsList) {
                if (createVpcEndpointConnectionNotificationRequestConnectionEventsListValue != null) {
                    request.addParameter("ConnectionEvents." + connectionEventsListIndex, StringConversion.fromString((String)createVpcEndpointConnectionNotificationRequestConnectionEventsListValue));
                }
                ++connectionEventsListIndex;
            }
        }
        if (createVpcEndpointConnectionNotificationRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createVpcEndpointConnectionNotificationRequest.clientToken()));
        }
        return request;
    }
}

