/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;

public class CreateRouteTableRequestMarshaller
implements Marshaller<Request<CreateRouteTableRequest>, CreateRouteTableRequest> {
    public Request<CreateRouteTableRequest> marshall(CreateRouteTableRequest createRouteTableRequest) {
        if (createRouteTableRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createRouteTableRequest, "Ec2Client");
        request.addParameter("Action", "CreateRouteTable");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteTableRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createRouteTableRequest.vpcId()));
        }
        return request;
    }
}

