/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.TelemetryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VgwTelemetry
implements ToCopyableBuilder<Builder, VgwTelemetry> {
    private final Integer acceptedRouteCount;
    private final Instant lastStatusChange;
    private final String outsideIpAddress;
    private final String status;
    private final String statusMessage;

    private VgwTelemetry(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public Integer acceptedRouteCount() {
        return this.acceptedRouteCount;
    }

    public Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public String outsideIpAddress() {
        return this.outsideIpAddress;
    }

    public TelemetryStatus status() {
        return TelemetryStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedRouteCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VgwTelemetry)) {
            return false;
        }
        VgwTelemetry other = (VgwTelemetry)obj;
        return Objects.equals(this.acceptedRouteCount(), other.acceptedRouteCount()) && Objects.equals(this.lastStatusChange(), other.lastStatusChange()) && Objects.equals(this.outsideIpAddress(), other.outsideIpAddress()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"VgwTelemetry").add("AcceptedRouteCount", (Object)this.acceptedRouteCount()).add("LastStatusChange", (Object)this.lastStatusChange()).add("OutsideIpAddress", (Object)this.outsideIpAddress()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptedRouteCount": {
                return Optional.ofNullable(clazz.cast(this.acceptedRouteCount()));
            }
            case "LastStatusChange": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChange()));
            }
            case "OutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.outsideIpAddress()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer acceptedRouteCount;
        private Instant lastStatusChange;
        private String outsideIpAddress;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VgwTelemetry model) {
            this.acceptedRouteCount(model.acceptedRouteCount);
            this.lastStatusChange(model.lastStatusChange);
            this.outsideIpAddress(model.outsideIpAddress);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return this.acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getOutsideIpAddress() {
            return this.outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public VgwTelemetry build() {
            return new VgwTelemetry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VgwTelemetry> {
        public Builder acceptedRouteCount(Integer var1);

        public Builder lastStatusChange(Instant var1);

        public Builder outsideIpAddress(String var1);

        public Builder status(String var1);

        public Builder status(TelemetryStatus var1);

        public Builder statusMessage(String var1);
    }
}

