/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageLocation
implements ToCopyableBuilder<Builder, StorageLocation> {
    private final String bucket;
    private final String key;

    private StorageLocation(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLocation)) {
            return false;
        }
        StorageLocation other = (StorageLocation)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key());
    }

    public String toString() {
        return ToString.builder((String)"StorageLocation").add("Bucket", (Object)this.bucket()).add("Key", (Object)this.key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLocation model) {
            this.bucket(model.bucket);
            this.key(model.key);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public StorageLocation build() {
            return new StorageLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageLocation> {
        public Builder bucket(String var1);

        public Builder key(String var1);
    }
}

