/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreditSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationResponseListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoring;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseLaunchTemplateData
implements ToCopyableBuilder<Builder, ResponseLaunchTemplateData> {
    private final String kernelId;
    private final Boolean ebsOptimized;
    private final LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;
    private final List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings;
    private final List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces;
    private final String imageId;
    private final String instanceType;
    private final String keyName;
    private final LaunchTemplatesMonitoring monitoring;
    private final LaunchTemplatePlacement placement;
    private final String ramDiskId;
    private final Boolean disableApiTermination;
    private final String instanceInitiatedShutdownBehavior;
    private final String userData;
    private final List<LaunchTemplateTagSpecification> tagSpecifications;
    private final List<ElasticGpuSpecificationResponse> elasticGpuSpecifications;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final LaunchTemplateInstanceMarketOptions instanceMarketOptions;
    private final CreditSpecification creditSpecification;
    private final LaunchTemplateCpuOptions cpuOptions;

    private ResponseLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String keyName() {
        return this.keyName;
    }

    public LaunchTemplatesMonitoring monitoring() {
        return this.monitoring;
    }

    public LaunchTemplatePlacement placement() {
        return this.placement;
    }

    public String ramDiskId() {
        return this.ramDiskId;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String userData() {
        return this.userData;
    }

    public List<LaunchTemplateTagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public List<ElasticGpuSpecificationResponse> elasticGpuSpecifications() {
        return this.elasticGpuSpecifications;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public LaunchTemplateInstanceMarketOptions instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public CreditSpecification creditSpecification() {
        return this.creditSpecification;
    }

    public LaunchTemplateCpuOptions cpuOptions() {
        return this.cpuOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseLaunchTemplateData)) {
            return false;
        }
        ResponseLaunchTemplateData other = (ResponseLaunchTemplateData)obj;
        return Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramDiskId(), other.ramDiskId()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.elasticGpuSpecifications(), other.elasticGpuSpecifications()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions());
    }

    public String toString() {
        return ToString.builder((String)"ResponseLaunchTemplateData").add("KernelId", (Object)this.kernelId()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("NetworkInterfaces", this.networkInterfaces()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamDiskId", (Object)this.ramDiskId()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("UserData", (Object)this.userData()).add("TagSpecifications", this.tagSpecifications()).add("ElasticGpuSpecifications", this.elasticGpuSpecifications()).add("SecurityGroupIds", this.securityGroupIds()).add("SecurityGroups", this.securityGroups()).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("CpuOptions", (Object)this.cpuOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamDiskId": {
                return Optional.ofNullable(clazz.cast(this.ramDiskId()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ElasticGpuSpecifications": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSpecifications()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String kernelId;
        private Boolean ebsOptimized;
        private LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;
        private List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String instanceType;
        private String keyName;
        private LaunchTemplatesMonitoring monitoring;
        private LaunchTemplatePlacement placement;
        private String ramDiskId;
        private Boolean disableApiTermination;
        private String instanceInitiatedShutdownBehavior;
        private String userData;
        private List<LaunchTemplateTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticGpuSpecificationResponse> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateInstanceMarketOptions instanceMarketOptions;
        private CreditSpecification creditSpecification;
        private LaunchTemplateCpuOptions cpuOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseLaunchTemplateData model) {
            this.kernelId(model.kernelId);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.networkInterfaces(model.networkInterfaces);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramDiskId(model.ramDiskId);
            this.disableApiTermination(model.disableApiTermination);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.userData(model.userData);
            this.tagSpecifications(model.tagSpecifications);
            this.elasticGpuSpecifications(model.elasticGpuSpecifications);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.creditSpecification(model.creditSpecification);
            this.cpuOptions(model.cpuOptions);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final LaunchTemplateIamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final Collection<LaunchTemplateBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(LaunchTemplateBlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (LaunchTemplateBlockDeviceMapping)((LaunchTemplateBlockDeviceMapping.Builder)LaunchTemplateBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Collection<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(LaunchTemplateInstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (LaunchTemplateInstanceNetworkInterfaceSpecification)((LaunchTemplateInstanceNetworkInterfaceSpecification.Builder)LaunchTemplateInstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final LaunchTemplatesMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(LaunchTemplatesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final LaunchTemplatePlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(LaunchTemplatePlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamDiskId() {
            return this.ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Collection<LaunchTemplateTagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(LaunchTemplateTagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (LaunchTemplateTagSpecification)((LaunchTemplateTagSpecification.Builder)LaunchTemplateTagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final Collection<ElasticGpuSpecificationResponse.Builder> getElasticGpuSpecifications() {
            return this.elasticGpuSpecifications != null ? (Collection)this.elasticGpuSpecifications.stream().map(ElasticGpuSpecificationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecificationResponse.Builder> ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Stream.of(elasticGpuSpecifications).map(c -> (ElasticGpuSpecificationResponse)((ElasticGpuSpecificationResponse.Builder)ElasticGpuSpecificationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
        }

        public final LaunchTemplateInstanceMarketOptions.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptions.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        public final CreditSpecification.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecification creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final void setCreditSpecification(CreditSpecification.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        public final LaunchTemplateCpuOptions.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public ResponseLaunchTemplateData build() {
            return new ResponseLaunchTemplateData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResponseLaunchTemplateData> {
        public Builder kernelId(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<LaunchTemplateIamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((LaunchTemplateIamInstanceProfileSpecification)((LaunchTemplateIamInstanceProfileSpecification.Builder)LaunchTemplateIamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder> ... var1);

        public Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder keyName(String var1);

        public Builder monitoring(LaunchTemplatesMonitoring var1);

        default public Builder monitoring(Consumer<LaunchTemplatesMonitoring.Builder> monitoring) {
            return this.monitoring((LaunchTemplatesMonitoring)((LaunchTemplatesMonitoring.Builder)LaunchTemplatesMonitoring.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(LaunchTemplatePlacement var1);

        default public Builder placement(Consumer<LaunchTemplatePlacement.Builder> placement) {
            return this.placement((LaunchTemplatePlacement)((LaunchTemplatePlacement.Builder)LaunchTemplatePlacement.builder().applyMutation(placement)).build());
        }

        public Builder ramDiskId(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder userData(String var1);

        public Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> var1);

        public Builder tagSpecifications(LaunchTemplateTagSpecification ... var1);

        public Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder> ... var1);

        public Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> var1);

        public Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse ... var1);

        public Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecificationResponse.Builder> ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions var1);

        default public Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptions.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((LaunchTemplateInstanceMarketOptions)((LaunchTemplateInstanceMarketOptions.Builder)LaunchTemplateInstanceMarketOptions.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder creditSpecification(CreditSpecification var1);

        default public Builder creditSpecification(Consumer<CreditSpecification.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecification)((CreditSpecification.Builder)CreditSpecification.builder().applyMutation(creditSpecification)).build());
        }

        public Builder cpuOptions(LaunchTemplateCpuOptions var1);

        default public Builder cpuOptions(Consumer<LaunchTemplateCpuOptions.Builder> cpuOptions) {
            return this.cpuOptions((LaunchTemplateCpuOptions)((LaunchTemplateCpuOptions.Builder)LaunchTemplateCpuOptions.builder().applyMutation(cpuOptions)).build());
        }
    }
}

