/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfaceAssociation
implements ToCopyableBuilder<Builder, NetworkInterfaceAssociation> {
    private final String allocationId;
    private final String associationId;
    private final String ipOwnerId;
    private final String publicDnsName;
    private final String publicIp;

    private NetworkInterfaceAssociation(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String associationId() {
        return this.associationId;
    }

    public String ipOwnerId() {
        return this.ipOwnerId;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAssociation)) {
            return false;
        }
        NetworkInterfaceAssociation other = (NetworkInterfaceAssociation)obj;
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.ipOwnerId(), other.ipOwnerId()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterfaceAssociation").add("AllocationId", (Object)this.allocationId()).add("AssociationId", (Object)this.associationId()).add("IpOwnerId", (Object)this.ipOwnerId()).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "IpOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ipOwnerId()));
            }
            case "PublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.publicDnsName()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String associationId;
        private String ipOwnerId;
        private String publicDnsName;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAssociation model) {
            this.allocationId(model.allocationId);
            this.associationId(model.associationId);
            this.ipOwnerId(model.ipOwnerId);
            this.publicDnsName(model.publicDnsName);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpOwnerId() {
            return this.ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public NetworkInterfaceAssociation build() {
            return new NetworkInterfaceAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfaceAssociation> {
        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder ipOwnerId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIp(String var1);
    }
}

