/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcAttributeRequest> {
    private final Boolean enableDnsHostnames;
    private final Boolean enableDnsSupport;
    private final String vpcId;

    private ModifyVpcAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
        this.vpcId = builder.vpcId;
    }

    public Boolean enableDnsHostnames() {
        return this.enableDnsHostnames;
    }

    public Boolean enableDnsSupport() {
        return this.enableDnsSupport;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcAttributeRequest)) {
            return false;
        }
        ModifyVpcAttributeRequest other = (ModifyVpcAttributeRequest)((Object)obj);
        return Objects.equals(this.enableDnsHostnames(), other.enableDnsHostnames()) && Objects.equals(this.enableDnsSupport(), other.enableDnsSupport()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcAttributeRequest").add("EnableDnsHostnames", (Object)this.enableDnsHostnames()).add("EnableDnsSupport", (Object)this.enableDnsSupport()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableDnsHostnames": {
                return Optional.ofNullable(clazz.cast(this.enableDnsHostnames()));
            }
            case "EnableDnsSupport": {
                return Optional.ofNullable(clazz.cast(this.enableDnsSupport()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean enableDnsHostnames;
        private Boolean enableDnsSupport;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcAttributeRequest model) {
            super(model);
            this.enableDnsHostnames(model.enableDnsHostnames);
            this.enableDnsSupport(model.enableDnsSupport);
            this.vpcId(model.vpcId);
        }

        public final Boolean getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public final Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
        }

        public final Boolean getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public final Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcAttributeRequest build() {
            return new ModifyVpcAttributeRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ModifyVpcAttributeRequest> {
        public Builder enableDnsHostnames(Boolean var1);

        public Builder enableDnsSupport(Boolean var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

