/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceCreditSpecificationRequest
implements ToCopyableBuilder<Builder, InstanceCreditSpecificationRequest> {
    private final String instanceId;
    private final String cpuCredits;

    private InstanceCreditSpecificationRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.cpuCredits = builder.cpuCredits;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String cpuCredits() {
        return this.cpuCredits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCredits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCreditSpecificationRequest)) {
            return false;
        }
        InstanceCreditSpecificationRequest other = (InstanceCreditSpecificationRequest)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.cpuCredits(), other.cpuCredits());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCreditSpecificationRequest").add("InstanceId", (Object)this.instanceId()).add("CpuCredits", (Object)this.cpuCredits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CpuCredits": {
                return Optional.ofNullable(clazz.cast(this.cpuCredits()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCreditSpecificationRequest model) {
            this.instanceId(model.instanceId);
            this.cpuCredits(model.cpuCredits);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getCpuCredits() {
            return this.cpuCredits;
        }

        @Override
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        public InstanceCreditSpecificationRequest build() {
            return new InstanceCreditSpecificationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCreditSpecificationRequest> {
        public Builder instanceId(String var1);

        public Builder cpuCredits(String var1);
    }
}

