/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesListRequestCopier;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateConfigRequest
implements ToCopyableBuilder<Builder, FleetLaunchTemplateConfigRequest> {
    private final FleetLaunchTemplateSpecificationRequest launchTemplateSpecification;
    private final List<FleetLaunchTemplateOverridesRequest> overrides;

    private FleetLaunchTemplateConfigRequest(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public FleetLaunchTemplateSpecificationRequest launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public List<FleetLaunchTemplateOverridesRequest> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateConfigRequest)) {
            return false;
        }
        FleetLaunchTemplateConfigRequest other = (FleetLaunchTemplateConfigRequest)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && Objects.equals(this.overrides(), other.overrides());
    }

    public String toString() {
        return ToString.builder((String)"FleetLaunchTemplateConfigRequest").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", this.overrides()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private FleetLaunchTemplateSpecificationRequest launchTemplateSpecification;
        private List<FleetLaunchTemplateOverridesRequest> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateConfigRequest model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecificationRequest.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequest launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecificationRequest.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        public final Collection<FleetLaunchTemplateOverridesRequest.Builder> getOverrides() {
            return this.overrides != null ? (Collection)this.overrides.stream().map(FleetLaunchTemplateOverridesRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder overrides(Collection<FleetLaunchTemplateOverridesRequest> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListRequestCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(FleetLaunchTemplateOverridesRequest ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<FleetLaunchTemplateOverridesRequest.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (FleetLaunchTemplateOverridesRequest)((FleetLaunchTemplateOverridesRequest.Builder)FleetLaunchTemplateOverridesRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOverrides(Collection<FleetLaunchTemplateOverridesRequest.BuilderImpl> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListRequestCopier.copyFromBuilder(overrides);
        }

        public FleetLaunchTemplateConfigRequest build() {
            return new FleetLaunchTemplateConfigRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetLaunchTemplateConfigRequest> {
        public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequest var1);

        default public Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecificationRequest.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((FleetLaunchTemplateSpecificationRequest)((FleetLaunchTemplateSpecificationRequest.Builder)FleetLaunchTemplateSpecificationRequest.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(Collection<FleetLaunchTemplateOverridesRequest> var1);

        public Builder overrides(FleetLaunchTemplateOverridesRequest ... var1);

        public Builder overrides(Consumer<FleetLaunchTemplateOverridesRequest.Builder> ... var1);
    }
}

