/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetActivityStatus;
import software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigListCopier;
import software.amazon.awssdk.services.ec2.model.FleetStateCode;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.OnDemandOptions;
import software.amazon.awssdk.services.ec2.model.SpotOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetData
implements ToCopyableBuilder<Builder, FleetData> {
    private final String activityStatus;
    private final Instant createTime;
    private final String fleetId;
    private final String fleetState;
    private final String clientToken;
    private final String excessCapacityTerminationPolicy;
    private final Double fulfilledCapacity;
    private final Double fulfilledOnDemandCapacity;
    private final List<FleetLaunchTemplateConfig> launchTemplateConfigs;
    private final TargetCapacitySpecification targetCapacitySpecification;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;
    private final SpotOptions spotOptions;
    private final OnDemandOptions onDemandOptions;
    private final List<Tag> tags;

    private FleetData(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.fleetId = builder.fleetId;
        this.fleetState = builder.fleetState;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.fulfilledOnDemandCapacity = builder.fulfilledOnDemandCapacity;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.spotOptions = builder.spotOptions;
        this.onDemandOptions = builder.onDemandOptions;
        this.tags = builder.tags;
    }

    public FleetActivityStatus activityStatus() {
        return FleetActivityStatus.fromValue(this.activityStatus);
    }

    public String activityStatusAsString() {
        return this.activityStatus;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public FleetStateCode fleetState() {
        return FleetStateCode.fromValue(this.fleetState);
    }

    public String fleetStateAsString() {
        return this.fleetState;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public Double fulfilledOnDemandCapacity() {
        return this.fulfilledOnDemandCapacity;
    }

    public List<FleetLaunchTemplateConfig> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public TargetCapacitySpecification targetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public FleetType type() {
        return FleetType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public SpotOptions spotOptions() {
        return this.spotOptions;
    }

    public OnDemandOptions onDemandOptions() {
        return this.onDemandOptions;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetData)) {
            return false;
        }
        FleetData other = (FleetData)obj;
        return Objects.equals(this.activityStatusAsString(), other.activityStatusAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetStateAsString(), other.fleetStateAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && Objects.equals(this.fulfilledCapacity(), other.fulfilledCapacity()) && Objects.equals(this.fulfilledOnDemandCapacity(), other.fulfilledOnDemandCapacity()) && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.targetCapacitySpecification(), other.targetCapacitySpecification()) && Objects.equals(this.terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.replaceUnhealthyInstances(), other.replaceUnhealthyInstances()) && Objects.equals(this.spotOptions(), other.spotOptions()) && Objects.equals(this.onDemandOptions(), other.onDemandOptions()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"FleetData").add("ActivityStatus", (Object)this.activityStatusAsString()).add("CreateTime", (Object)this.createTime()).add("FleetId", (Object)this.fleetId()).add("FleetState", (Object)this.fleetStateAsString()).add("ClientToken", (Object)this.clientToken()).add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("FulfilledCapacity", (Object)this.fulfilledCapacity()).add("FulfilledOnDemandCapacity", (Object)this.fulfilledOnDemandCapacity()).add("LaunchTemplateConfigs", this.launchTemplateConfigs()).add("TargetCapacitySpecification", (Object)this.targetCapacitySpecification()).add("TerminateInstancesWithExpiration", (Object)this.terminateInstancesWithExpiration()).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("ReplaceUnhealthyInstances", (Object)this.replaceUnhealthyInstances()).add("SpotOptions", (Object)this.spotOptions()).add("OnDemandOptions", (Object)this.onDemandOptions()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityStatus": {
                return Optional.ofNullable(clazz.cast(this.activityStatusAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetState": {
                return Optional.ofNullable(clazz.cast(this.fleetStateAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "FulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledCapacity()));
            }
            case "FulfilledOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledOnDemandCapacity()));
            }
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "TargetCapacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.targetCapacitySpecification()));
            }
            case "TerminateInstancesWithExpiration": {
                return Optional.ofNullable(clazz.cast(this.terminateInstancesWithExpiration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "ReplaceUnhealthyInstances": {
                return Optional.ofNullable(clazz.cast(this.replaceUnhealthyInstances()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
            case "OnDemandOptions": {
                return Optional.ofNullable(clazz.cast(this.onDemandOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String activityStatus;
        private Instant createTime;
        private String fleetId;
        private String fleetState;
        private String clientToken;
        private String excessCapacityTerminationPolicy;
        private Double fulfilledCapacity;
        private Double fulfilledOnDemandCapacity;
        private List<FleetLaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private TargetCapacitySpecification targetCapacitySpecification;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;
        private SpotOptions spotOptions;
        private OnDemandOptions onDemandOptions;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetData model) {
            this.activityStatus(model.activityStatus);
            this.createTime(model.createTime);
            this.fleetId(model.fleetId);
            this.fleetState(model.fleetState);
            this.clientToken(model.clientToken);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.fulfilledCapacity(model.fulfilledCapacity);
            this.fulfilledOnDemandCapacity(model.fulfilledOnDemandCapacity);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.targetCapacitySpecification(model.targetCapacitySpecification);
            this.terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            this.spotOptions(model.spotOptions);
            this.onDemandOptions(model.onDemandOptions);
            this.tags(model.tags);
        }

        public final String getActivityStatus() {
            return this.activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(FleetActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetState() {
            return this.fleetState;
        }

        @Override
        public final Builder fleetState(String fleetState) {
            this.fleetState = fleetState;
            return this;
        }

        @Override
        public final Builder fleetState(FleetStateCode fleetState) {
            this.fleetState(fleetState.toString());
            return this;
        }

        public final void setFleetState(String fleetState) {
            this.fleetState = fleetState;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final Double getFulfilledOnDemandCapacity() {
            return this.fulfilledOnDemandCapacity;
        }

        @Override
        public final Builder fulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
            return this;
        }

        public final void setFulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
        }

        public final Collection<FleetLaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            return this.launchTemplateConfigs != null ? (Collection)this.launchTemplateConfigs.stream().map(FleetLaunchTemplateConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfig ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (FleetLaunchTemplateConfig)((FleetLaunchTemplateConfig.Builder)FleetLaunchTemplateConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final TargetCapacitySpecification.Builder getTargetCapacitySpecification() {
            return this.targetCapacitySpecification != null ? this.targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecification.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        public final OnDemandOptions.Builder getOnDemandOptions() {
            return this.onDemandOptions != null ? this.onDemandOptions.toBuilder() : null;
        }

        @Override
        public final Builder onDemandOptions(OnDemandOptions onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        public final void setOnDemandOptions(OnDemandOptions.BuilderImpl onDemandOptions) {
            this.onDemandOptions = onDemandOptions != null ? onDemandOptions.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public FleetData build() {
            return new FleetData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetData> {
        public Builder activityStatus(String var1);

        public Builder activityStatus(FleetActivityStatus var1);

        public Builder createTime(Instant var1);

        public Builder fleetId(String var1);

        public Builder fleetState(String var1);

        public Builder fleetState(FleetStateCode var1);

        public Builder clientToken(String var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder fulfilledOnDemandCapacity(Double var1);

        public Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> var1);

        public Builder launchTemplateConfigs(FleetLaunchTemplateConfig ... var1);

        public Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder> ... var1);

        public Builder targetCapacitySpecification(TargetCapacitySpecification var1);

        default public Builder targetCapacitySpecification(Consumer<TargetCapacitySpecification.Builder> targetCapacitySpecification) {
            return this.targetCapacitySpecification((TargetCapacitySpecification)((TargetCapacitySpecification.Builder)TargetCapacitySpecification.builder().applyMutation(targetCapacitySpecification)).build());
        }

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);

        public Builder spotOptions(SpotOptions var1);

        default public Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return this.spotOptions((SpotOptions)((SpotOptions.Builder)SpotOptions.builder().applyMutation(spotOptions)).build());
        }

        public Builder onDemandOptions(OnDemandOptions var1);

        default public Builder onDemandOptions(Consumer<OnDemandOptions.Builder> onDemandOptions) {
            return this.onDemandOptions((OnDemandOptions)((OnDemandOptions.Builder)OnDemandOptions.builder().applyMutation(onDemandOptions)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

