/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.ContainerFormat;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportToS3TaskSpecification
implements ToCopyableBuilder<Builder, ExportToS3TaskSpecification> {
    private final String containerFormat;
    private final String diskImageFormat;
    private final String s3Bucket;
    private final String s3Prefix;

    private ExportToS3TaskSpecification(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
    }

    public ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(this.containerFormat);
    }

    public String containerFormatAsString() {
        return this.containerFormat;
    }

    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public String diskImageFormatAsString() {
        return this.diskImageFormat;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3TaskSpecification)) {
            return false;
        }
        ExportToS3TaskSpecification other = (ExportToS3TaskSpecification)obj;
        return Objects.equals(this.containerFormatAsString(), other.containerFormatAsString()) && Objects.equals(this.diskImageFormatAsString(), other.diskImageFormatAsString()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix());
    }

    public String toString() {
        return ToString.builder((String)"ExportToS3TaskSpecification").add("ContainerFormat", (Object)this.containerFormatAsString()).add("DiskImageFormat", (Object)this.diskImageFormatAsString()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerFormat": {
                return Optional.ofNullable(clazz.cast(this.containerFormatAsString()));
            }
            case "DiskImageFormat": {
                return Optional.ofNullable(clazz.cast(this.diskImageFormatAsString()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String containerFormat;
        private String diskImageFormat;
        private String s3Bucket;
        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3TaskSpecification model) {
            this.containerFormat(model.containerFormat);
            this.diskImageFormat(model.diskImageFormat);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public ExportToS3TaskSpecification build() {
            return new ExportToS3TaskSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportToS3TaskSpecification> {
        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);
    }
}

