/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsEntry
implements ToCopyableBuilder<Builder, DnsEntry> {
    private final String dnsName;
    private final String hostedZoneId;

    private DnsEntry(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsEntry)) {
            return false;
        }
        DnsEntry other = (DnsEntry)obj;
        return Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public String toString() {
        return ToString.builder((String)"DnsEntry").add("DnsName", (Object)this.dnsName()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsName;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsEntry model) {
            this.dnsName(model.dnsName);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public DnsEntry build() {
            return new DnsEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DnsEntry> {
        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);
    }
}

