/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.HistoryRecord;
import software.amazon.awssdk.services.ec2.model.HistoryRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetRequestHistoryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
    private final List<HistoryRecord> historyRecords;
    private final Instant lastEvaluatedTime;
    private final String nextToken;
    private final String spotFleetRequestId;
    private final Instant startTime;

    private DescribeSpotFleetRequestHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.startTime = builder.startTime;
    }

    public List<HistoryRecord> historyRecords() {
        return this.historyRecords;
    }

    public Instant lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.historyRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestHistoryResponse)) {
            return false;
        }
        DescribeSpotFleetRequestHistoryResponse other = (DescribeSpotFleetRequestHistoryResponse)((Object)obj);
        return Objects.equals(this.historyRecords(), other.historyRecords()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSpotFleetRequestHistoryResponse").add("HistoryRecords", this.historyRecords()).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HistoryRecords": {
                return Optional.ofNullable(clazz.cast(this.historyRecords()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<HistoryRecord> historyRecords = DefaultSdkAutoConstructList.getInstance();
        private Instant lastEvaluatedTime;
        private String nextToken;
        private String spotFleetRequestId;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestHistoryResponse model) {
            super(model);
            this.historyRecords(model.historyRecords);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.nextToken(model.nextToken);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.startTime(model.startTime);
        }

        public final Collection<HistoryRecord.Builder> getHistoryRecords() {
            return this.historyRecords != null ? (Collection)this.historyRecords.stream().map(HistoryRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder historyRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(HistoryRecord ... historyRecords) {
            this.historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(Consumer<HistoryRecord.Builder> ... historyRecords) {
            this.historyRecords(Stream.of(historyRecords).map(c -> (HistoryRecord)((HistoryRecord.Builder)HistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHistoryRecords(Collection<HistoryRecord.BuilderImpl> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copyFromBuilder(historyRecords);
        }

        public final Instant getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        @Override
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public DescribeSpotFleetRequestHistoryResponse build() {
            return new DescribeSpotFleetRequestHistoryResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
        public Builder historyRecords(Collection<HistoryRecord> var1);

        public Builder historyRecords(HistoryRecord ... var1);

        public Builder historyRecords(Consumer<HistoryRecord.Builder> ... var1);

        public Builder lastEvaluatedTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);

        public Builder startTime(Instant var1);
    }
}

